/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast.context;

import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContext;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContextSource;
import io.github.pistonpoek.magicalscepter.spell.position.AbsolutePositionSource;
import io.github.pistonpoek.magicalscepter.spell.rotation.AbsoluteRotationSource;
import io.github.pistonpoek.magicalscepter.spell.target.AbsoluteTargetSource;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public record ContextSourceList(List<SpellContextSource> sources) implements SpellContextSource
{
    public static final MapCodec<ContextSourceList> MAP_CODEC = SpellContextSource.CODEC.listOf().xmap(ContextSourceList::new, ContextSourceList::sources).fieldOf("sources");
    public static final Codec<ContextSourceList> CODEC = MAP_CODEC.codec();

    public ContextSourceList(SpellContext context) {
        this(List.of(new AbsoluteTargetSource(context.target().method_5667()), new AbsolutePositionSource(context.position()), new AbsoluteRotationSource(context.pitch(), context.yaw())));
    }

    @Override
    public SpellContext getContext(@NotNull SpellContext spellContext) {
        for (SpellContextSource contextSource : this.sources) {
            spellContext = contextSource.getContext(spellContext);
        }
        return spellContext;
    }

    public ContextSourceList append(SpellContextSource contextSource) {
        if (contextSource instanceof ContextSourceList) {
            ((ContextSourceList)contextSource).sources.forEach(this::append);
            return this;
        }
        this.sources.add(contextSource);
        return this;
    }

    public MapCodec<ContextSourceList> getSourceCodec() {
        return MAP_CODEC;
    }
}

