/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast.context;

import io.github.pistonpoek.magicalscepter.spell.cast.SpellCast;
import io.github.pistonpoek.magicalscepter.spell.cast.context.ContextSourceList;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContext;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContextSource;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.CastTransformer;
import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1309;

public class SpellCasting
implements Cloneable {
    protected final SpellCast spellCast;
    protected final class_1309 caster;
    private ContextSourceList contextSource = new ContextSourceList(new ArrayList<SpellContextSource>());
    private SpellContext context;

    public SpellCasting(SpellCast spellCast, class_1309 caster) {
        this.spellCast = spellCast;
        this.caster = caster;
        this.context = new SpellContext(caster);
    }

    public SpellCasting(SpellCast spellCast, class_1309 caster, SpellContextSource contextSource) {
        this(spellCast, caster);
        this.addContext(contextSource);
    }

    public SpellCast getSpellCast() {
        return this.spellCast;
    }

    public class_1309 getCaster() {
        return this.caster;
    }

    public SpellContext getContext() {
        return this.context;
    }

    public SpellContextSource getContextSource() {
        return this.contextSource;
    }

    public SpellCasting addContext(SpellContextSource contextSource) {
        this.contextSource.append(contextSource);
        this.context = contextSource.getContext(this.context);
        return this;
    }

    public void invoke() {
        SpellCast spellCast = this.getSpellCast();
        List<CastTransformer> transformers = spellCast.transformers();
        if (!transformers.isEmpty()) {
            transformers.getFirst().transform(new SpellCasting(new SpellCast(spellCast.effects(), transformers.stream().skip(1L).toList()), this.getCaster(), this.getContextSource())).forEach(SpellCasting::invoke);
        } else {
            this.getContext().apply(spellCast.effects());
        }
    }

    public SpellCasting clone() {
        try {
            SpellCasting clone = (SpellCasting)super.clone();
            clone.contextSource = new ContextSourceList(new ArrayList<SpellContextSource>(this.contextSource.sources()));
            return clone;
        }
        catch (CloneNotSupportedException e) {
            throw new AssertionError();
        }
    }
}

