/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast.delay;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.MagicalScepter;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellCasting;
import io.github.pistonpoek.magicalscepter.spell.cast.delay.ScheduledSpellCasting;
import io.github.pistonpoek.magicalscepter.spell.cast.delay.SpellCastingScheduler;
import io.github.pistonpoek.magicalscepter.spell.cast.delay.SpellCastingTimerCallback;
import io.github.pistonpoek.magicalscepter.util.ModIdentifier;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_10741;
import net.minecraft.class_1282;
import net.minecraft.class_1309;
import net.minecraft.class_18;
import net.minecraft.class_3218;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;

public class SpellCastingManager
extends class_18 {
    private static final int MAX_CASTER_CASTINGS = Integer.MAX_VALUE;
    private static final String ID = ModIdentifier.key("spell_castings", "_");
    public static final Codec<SpellCastingManager> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Codec.unboundedMap((Codec)Codec.STRING.xmap(UUID::fromString, UUID::toString), (Codec)Codec.unboundedMap((Codec)Codec.STRING.xmap(Integer::parseInt, Object::toString), ScheduledSpellCasting.CODEC)).fieldOf("scheduled_castings").forGetter(spellCastingManager -> spellCastingManager.scheduledCastings), (App)Codec.INT.fieldOf("start_key").forGetter(spellCastingManager -> spellCastingManager.startKey)).apply((Applicative)instance, SpellCastingManager::new));
    private final Map<UUID, Map<Integer, ScheduledSpellCasting>> scheduledCastings;
    private int startKey;

    private SpellCastingManager(Map<UUID, Map<Integer, ScheduledSpellCasting>> scheduledCastings, int startKey) {
        this.scheduledCastings = new HashMap<UUID, Map<Integer, ScheduledSpellCasting>>(scheduledCastings);
        for (Map.Entry<UUID, Map<Integer, ScheduledSpellCasting>> scheduledCasting : scheduledCastings.entrySet()) {
            this.scheduledCastings.put(scheduledCasting.getKey(), new HashMap<Integer, ScheduledSpellCasting>(scheduledCasting.getValue()));
        }
        this.startKey = startKey;
    }

    public SpellCastingManager() {
        this(new HashMap<UUID, Map<Integer, ScheduledSpellCasting>>(), 0);
    }

    public static SpellCastingManager load(MinecraftServer server) {
        return (SpellCastingManager)server.method_30002().method_17983().method_17924(SpellCastingManager.getPersistentStateType());
    }

    public void schedule(class_3218 world, SpellCasting spellCasting, int delay) {
        ScheduledSpellCasting scheduledSpellCasting = new ScheduledSpellCasting(spellCasting.clone());
        UUID casterUuid = spellCasting.getCaster().method_5667();
        int key = this.generateKey(casterUuid);
        if (key == -1) {
            MagicalScepter.LOGGER.info("Max casting amount reached for caster {}", (Object)casterUuid);
            return;
        }
        this.store(scheduledSpellCasting, casterUuid, key);
        SpellCastingScheduler.schedule(world, new SpellCastingTimerCallback(casterUuid, key), delay);
    }

    private void store(ScheduledSpellCasting scheduledSpellCasting, UUID casterUuid, int key) {
        if (!this.scheduledCastings.containsKey(casterUuid)) {
            this.scheduledCastings.put(casterUuid, new HashMap());
        }
        this.scheduledCastings.get(casterUuid).put(key, scheduledSpellCasting);
        this.method_80();
    }

    Optional<SpellCasting> retrieve(MinecraftServer server, UUID casterUuid, int key) {
        if (!this.scheduledCastings.containsKey(casterUuid)) {
            return Optional.empty();
        }
        if (!this.scheduledCastings.get(casterUuid).containsKey(key)) {
            return Optional.empty();
        }
        this.method_80();
        if (this.scheduledCastings.get(casterUuid).size() == 1) {
            return this.scheduledCastings.remove(casterUuid).remove(key).load(server);
        }
        return this.scheduledCastings.get(casterUuid).remove(key).load(server);
    }

    public boolean clear(MinecraftServer server, UUID casterUuid) {
        if (!this.scheduledCastings.containsKey(casterUuid)) {
            return false;
        }
        if (this.scheduledCastings.get(casterUuid).isEmpty()) {
            return false;
        }
        for (int key : this.scheduledCastings.remove(casterUuid).keySet()) {
            SpellCastingScheduler.clear(server, new SpellCastingTimerCallback(casterUuid, key));
        }
        this.method_80();
        return true;
    }

    private int generateKey(UUID casterUuid) {
        int nextKey = this.startKey;
        if (!this.scheduledCastings.containsKey(casterUuid)) {
            this.startKey = nextKey + 1;
            return nextKey;
        }
        do {
            if (this.scheduledCastings.get(casterUuid).containsKey(nextKey)) continue;
            this.startKey = nextKey + 1;
            return nextKey;
        } while (++nextKey != this.startKey);
        MagicalScepter.LOGGER.warn("Caster reached scheduled casting limit of {}", (Object)Integer.MAX_VALUE);
        return -1;
    }

    public static class_10741<SpellCastingManager> getPersistentStateType() {
        return new class_10741(ID, SpellCastingManager::new, CODEC, null);
    }

    public static boolean clear(@NotNull class_1309 entity) {
        MinecraftServer server = entity.method_73183().method_8503();
        if (server == null) {
            return false;
        }
        return SpellCastingManager.load(server).clear(server, entity.method_5667());
    }

    public static void afterDeath(class_1309 entity, class_1282 damageSource) {
        if (entity == null) {
            return;
        }
        SpellCastingManager.clear(entity);
    }
}

