/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellCasting;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContext;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.CastTransformer;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.DelayCastTransformer;
import io.github.pistonpoek.magicalscepter.spell.position.AbsolutePositionSource;
import io.github.pistonpoek.magicalscepter.spell.position.PositionSource;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_243;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;

public record LineCastTransformer(PositionSource position, int amount, float stepDelay) implements CastTransformer
{
    public static final MapCodec<LineCastTransformer> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PositionSource.CODEC.fieldOf("position").forGetter(LineCastTransformer::position), (App)class_5699.field_33441.fieldOf("amount").forGetter(LineCastTransformer::amount), (App)class_5699.field_53754.optionalFieldOf("step_delay", (Object)Float.valueOf(0.0f)).forGetter(LineCastTransformer::stepDelay)).apply((Applicative)instance, LineCastTransformer::new));

    @Override
    public Collection<SpellCasting> transform(@NotNull SpellCasting casting) {
        SpellContext context = casting.getContext();
        class_243 startPos = context.position();
        class_243 lineVector = this.position.getPosition(context).method_1020(startPos);
        ArrayList<SpellCasting> casts = new ArrayList<SpellCasting>();
        for (int i = 0; i < this.amount; ++i) {
            SpellCasting pointCast = DelayCastTransformer.delay(casting, (int)((float)i * this.stepDelay));
            pointCast.addContext(AbsolutePositionSource.builder(startPos.method_1019(lineVector.method_1021((double)i / (double)(this.amount - 1)))).build());
            casts.add(pointCast);
        }
        return casts;
    }

    public static Builder builder(int amount, PositionSource position) {
        return new Builder(position, amount);
    }

    public MapCodec<LineCastTransformer> getCodec() {
        return MAP_CODEC;
    }

    public static class Builder {
        private final PositionSource position;
        private final int amount;
        private float stepDelay = 0.0f;

        public Builder(PositionSource position, int amount) {
            this.position = position;
            this.amount = amount;
        }

        public Builder stepDelay(float stepDelay) {
            this.stepDelay = stepDelay;
            return this;
        }

        public LineCastTransformer build() {
            return new LineCastTransformer(this.position, this.amount, this.stepDelay);
        }
    }
}

