/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellCasting;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContext;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.CastTransformer;
import io.github.pistonpoek.magicalscepter.spell.position.AbsolutePositionSource;
import io.github.pistonpoek.magicalscepter.spell.target.AbsoluteTargetSource;
import io.github.pistonpoek.magicalscepter.util.RotationVector;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1297;
import net.minecraft.class_1301;
import net.minecraft.class_1675;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_3542;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_3966;
import org.jetbrains.annotations.NotNull;

public record RayCastTransformer(Target target, double range, boolean require) implements CastTransformer
{
    public static final MapCodec<RayCastTransformer> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Target.CODEC.fieldOf("target").forGetter(RayCastTransformer::target), (App)Codec.DOUBLE.fieldOf("range").forGetter(RayCastTransformer::range), (App)Codec.BOOL.optionalFieldOf("require", (Object)true).forGetter(RayCastTransformer::require)).apply((Applicative)instance, RayCastTransformer::new));

    @Override
    public Collection<SpellCasting> transform(@NotNull SpellCasting casting) {
        SpellContext context = casting.getContext();
        class_243 rotationVector = RotationVector.get(context.pitch(), context.yaw()).method_1029();
        class_243 endPosition = context.position().method_1031(rotationVector.field_1352 * this.range, rotationVector.field_1351 * this.range, rotationVector.field_1350 * this.range);
        switch (this.target.ordinal()) {
            case 0: {
                class_3965 hitResult = RayCastTransformer.blockRaycast(this.range, context.target(), context.position(), endPosition);
                if (hitResult.method_17783() == class_239.class_240.field_1333 && this.require) {
                    return List.of();
                }
                casting.addContext(AbsolutePositionSource.builder(hitResult.method_17784()).build());
                break;
            }
            case 1: {
                Optional<class_3966> entityHitResult = RayCastTransformer.entityRayCast(this.range, (class_1297)context.caster(), context.position(), endPosition);
                if (entityHitResult.isEmpty()) {
                    return List.of();
                }
                casting.addContext(new AbsoluteTargetSource(entityHitResult.get().method_17782().method_5667()));
            }
        }
        return List.of(casting);
    }

    private static class_3965 blockRaycast(double range, class_1297 target, class_243 position, class_243 endPosition) {
        class_3965 hitResult = target.method_73183().method_17742(new class_3959(position, endPosition, class_3959.class_3960.field_17558, class_3959.class_242.field_1348, target));
        class_243 hitResultPos = hitResult.method_17784();
        if (!hitResultPos.method_24802((class_2374)position, range)) {
            class_2350 direction = class_2350.method_10142((double)(hitResultPos.field_1352 - position.field_1352), (double)(hitResultPos.field_1351 - position.field_1351), (double)(hitResultPos.field_1350 - position.field_1350));
            return class_3965.method_17778((class_243)hitResultPos, (class_2350)direction, (class_2338)class_2338.method_49638((class_2374)hitResultPos));
        }
        return hitResult;
    }

    private static Optional<class_3966> entityRayCast(double range, class_1297 target, class_243 position, class_243 endPosition) {
        Predicate<class_1297> entityPredicate;
        class_238 box;
        class_3966 entityHitResult;
        class_3965 hitResult = RayCastTransformer.blockRaycast(range, target, position, endPosition);
        double distance = hitResult.method_17784().method_1022(position);
        if (hitResult.method_17783() != class_239.class_240.field_1333) {
            range = distance;
        }
        return (entityHitResult = class_1675.method_18075((class_1297)target, (class_243)position, (class_243)endPosition, (class_238)(box = class_238.method_54784((class_2338)class_2338.method_49638((class_2374)position), (class_2338)class_2338.method_49638((class_2374)endPosition)).method_1014(1.0)), entityPredicate = entity -> !entity.method_7325() && class_1301.field_6157.test(entity), (double)Math.pow(range, 2.0))) != null && entityHitResult.method_17784().method_1022(position) < distance ? Optional.of(entityHitResult) : Optional.empty();
    }

    public MapCodec<RayCastTransformer> getCodec() {
        return MAP_CODEC;
    }

    public static Builder builder(Target target, double range) {
        return new Builder(target, range);
    }

    public static enum Target implements class_3542
    {
        BLOCK("block"),
        ENTITY("entity");

        public static final Codec<Target> CODEC;
        private final String identifier;

        private Target(String identifier) {
            this.identifier = identifier;
        }

        public String method_15434() {
            return this.identifier;
        }

        static {
            CODEC = class_3542.method_53955(Target::values);
        }
    }

    public static class Builder {
        private final Target target;
        private final double range;
        private boolean require = true;

        public Builder(Target target, double range) {
            this.target = target;
            this.range = range;
        }

        public Builder require(boolean require) {
            this.require = require;
            return this;
        }

        public RayCastTransformer build() {
            return new RayCastTransformer(this.target, this.range, this.require);
        }
    }
}

