/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellCasting;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.CastTransformer;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.DelayCastTransformer;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;

public record RepeatCastTransformer(int amount, float stepDelay) implements CastTransformer
{
    public static final MapCodec<RepeatCastTransformer> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_5699.field_33441.fieldOf("amount").forGetter(RepeatCastTransformer::amount), (App)class_5699.field_53754.optionalFieldOf("step_delay", (Object)Float.valueOf(0.0f)).forGetter(RepeatCastTransformer::stepDelay)).apply((Applicative)instance, RepeatCastTransformer::new));

    @Override
    public Collection<SpellCasting> transform(@NotNull SpellCasting casting) {
        ArrayList<SpellCasting> casts = new ArrayList<SpellCasting>();
        for (int i = 0; i < this.amount; ++i) {
            casts.add(DelayCastTransformer.delay(casting, (int)((float)i * this.stepDelay)));
        }
        return casts;
    }

    public MapCodec<RepeatCastTransformer> getCodec() {
        return MAP_CODEC;
    }

    public static Builder builder(int amount) {
        return new Builder(amount);
    }

    public static class Builder {
        private final int amount;
        private float stepDelay;

        public Builder(int amount) {
            this.amount = amount;
        }

        public Builder stepDelay(float stepDelay) {
            this.stepDelay = stepDelay;
            return this;
        }

        public RepeatCastTransformer build() {
            return new RepeatCastTransformer(this.amount, this.stepDelay);
        }
    }
}

