/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellCasting;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.CastTransformer;
import io.github.pistonpoek.magicalscepter.spell.position.AbsolutePositionSource;
import io.github.pistonpoek.magicalscepter.spell.position.PositionSource;
import java.util.Collection;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_243;
import net.minecraft.class_265;
import net.minecraft.class_2680;
import org.jetbrains.annotations.NotNull;

public record SurfaceCastTransformer(float distance, boolean require, Optional<PositionSource> position) implements CastTransformer
{
    public static final MapCodec<SurfaceCastTransformer> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.FLOAT.fieldOf("distance").forGetter(SurfaceCastTransformer::distance), (App)Codec.BOOL.optionalFieldOf("require", (Object)true).forGetter(SurfaceCastTransformer::require), (App)PositionSource.CODEC.optionalFieldOf("position").forGetter(SurfaceCastTransformer::position)).apply((Applicative)instance, SurfaceCastTransformer::new));

    @Override
    public Collection<SpellCasting> transform(@NotNull SpellCasting casting) {
        Optional<class_243> value = this.getSurfacePosition(casting);
        if (value.isEmpty()) {
            return this.require ? List.of() : List.of(casting);
        }
        casting.addContext(AbsolutePositionSource.builder(value.get()).build());
        return List.of(casting);
    }

    private Optional<class_243> getSurfacePosition(@NotNull SpellCasting cast) {
        double bottom;
        double top;
        class_1937 world = cast.getCaster().method_73183();
        class_243 castPosition = cast.getContext().position();
        if (this.position.isPresent()) {
            class_243 diffPosition = this.position.get().getPosition(cast.getContext());
            top = Math.max(castPosition.field_1351, diffPosition.field_1351) + (double)this.distance;
            bottom = Math.min(castPosition.field_1351, diffPosition.field_1351) - (double)this.distance;
        } else {
            top = castPosition.field_1351 + (double)this.distance;
            bottom = castPosition.field_1351 - (double)this.distance;
        }
        class_2338 blockPosition = class_2338.method_49637((double)castPosition.method_10216(), (double)top, (double)castPosition.method_10215());
        boolean foundSurface = false;
        double blockHeight = 0.0;
        do {
            class_2680 blockState;
            class_265 voxelShape;
            class_2338 LoweredBlockPos;
            class_2680 LoweredBlockState;
            if (!(LoweredBlockState = world.method_8320(LoweredBlockPos = blockPosition.method_10074())).method_26206((class_1922)world, LoweredBlockPos, class_2350.field_11036)) continue;
            if (!world.method_22347(blockPosition) && !(voxelShape = (blockState = world.method_8320(blockPosition)).method_26220((class_1922)world, blockPosition)).method_1110()) {
                blockHeight = voxelShape.method_1105(class_2350.class_2351.field_11052);
            }
            foundSurface = true;
            break;
        } while ((double)(blockPosition = blockPosition.method_10074()).method_10264() >= bottom);
        if (foundSurface) {
            return Optional.of(new class_243(castPosition.method_10216(), (double)blockPosition.method_10264() + blockHeight, castPosition.method_10215()));
        }
        return Optional.empty();
    }

    public MapCodec<SurfaceCastTransformer> getCodec() {
        return MAP_CODEC;
    }

    public static Builder builder(float distance) {
        return new Builder(distance);
    }

    public static class Builder {
        private final float distance;
        private boolean require = true;
        private PositionSource position = null;

        public Builder(float distance) {
            this.distance = distance;
        }

        public Builder position(PositionSource position) {
            this.position = position;
            return this;
        }

        public Builder require(boolean require) {
            this.require = require;
            return this;
        }

        public SurfaceCastTransformer build() {
            return new SurfaceCastTransformer(this.distance, this.require, Optional.ofNullable(this.position));
        }
    }
}

