/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.effect;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.MagicalScepter;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContext;
import io.github.pistonpoek.magicalscepter.spell.effect.SpellEffect;
import io.github.pistonpoek.magicalscepter.spell.rotation.RotationSource;
import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_1295;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1538;
import net.minecraft.class_1634;
import net.minecraft.class_1669;
import net.minecraft.class_1676;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2378;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3730;
import net.minecraft.class_4844;
import net.minecraft.class_5321;
import net.minecraft.class_5425;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_6898;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public record SummonEntitySpellEffect(class_6885<class_1299<?>> entityTypes, List<SpellEffect> effects, Optional<class_2487> nbt) implements SpellEffect
{
    public static final MapCodec<SummonEntitySpellEffect> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_6898.method_40388((class_5321)class_7924.field_41266, (Codec)class_7923.field_41177.method_40294(), (boolean)false).fieldOf("entity").forGetter(SummonEntitySpellEffect::entityTypes), (App)SpellEffect.CODEC.listOf().fieldOf("effects").forGetter(SummonEntitySpellEffect::effects), (App)class_2487.field_25128.optionalFieldOf("nbt").forGetter(SummonEntitySpellEffect::nbt)).apply((Applicative)instance, SummonEntitySpellEffect::new));

    @Override
    public void apply(SpellContext context) {
        class_1297 entity;
        class_243 position = context.position();
        class_5819 random = context.getRandom();
        class_3218 world = context.getWorld();
        class_1297 target = context.target();
        class_1309 caster = context.caster();
        class_2338 blockPos = class_2338.method_49638((class_2374)position);
        if (!class_1937.method_25953((class_2338)blockPos)) {
            MagicalScepter.LOGGER.info("Failed to summon entity spell effect as position is not valid");
            return;
        }
        Optional optionalEntityType = this.entityTypes.method_40243(random);
        if (optionalEntityType.isEmpty()) {
            MagicalScepter.LOGGER.info("Failed to summon entity spell effect as entity type is missing");
            return;
        }
        class_2378 entityTypeRegistry = world.method_30349().method_30530(class_7924.field_41266);
        class_1299 entityType = (class_1299)((class_6880)optionalEntityType.get()).comp_349();
        if (!entityType.method_5896()) {
            MagicalScepter.LOGGER.info("Failed to summon entity spell effect as entity type is not summonable");
            return;
        }
        class_2960 entityTypeIdentifier = entityTypeRegistry.method_10221((Object)entityType);
        if (entityTypeIdentifier == null) {
            MagicalScepter.LOGGER.info("Failed to summon entity spell effect as entity type id is invalid");
            return;
        }
        class_2487 nbtCompound = this.nbt.orElse(new class_2487());
        nbtCompound.method_10582("id", entityTypeIdentifier.toString());
        if (entityType == class_1299.field_6100) {
            SummonEntitySpellEffect.initializeShulkerBulletNbtCompound(nbtCompound, context);
        }
        if ((entity = class_1299.method_71371((class_2487)nbtCompound, (class_1937)world, (class_3730)class_3730.field_16471, summonedEntity -> {
            summonedEntity.method_5808(position.field_1352, position.field_1351, position.field_1350, context.yaw(), context.pitch());
            return summonedEntity;
        })) instanceof class_1308) {
            class_1308 mobEntity = (class_1308)entity;
            mobEntity.method_5943((class_5425)world, world.method_8404(entity.method_24515()), class_3730.field_16471, null);
        }
        if (!world.method_30736(entity)) {
            MagicalScepter.LOGGER.info("Failed to summon entity spell effect in the world due to conflicting UUIDs");
            return;
        }
        if (entity != null) {
            if (entity instanceof class_1538) {
                class_1538 lightningEntity = (class_1538)entity;
                if (target instanceof class_3222) {
                    class_3222 serverPlayerEntity = (class_3222)target;
                    lightningEntity.method_6961(serverPlayerEntity);
                }
            }
            if (entity instanceof class_1676) {
                class_1676 projectileEntity = (class_1676)entity;
                projectileEntity.method_7432((class_1297)caster);
            }
            if (entity instanceof class_1295) {
                class_1295 areaEffectCloudEntity = (class_1295)entity;
                areaEffectCloudEntity.method_5607(caster);
            }
            if (entity instanceof class_1669) {
                class_1669 evokerFangsEntity = (class_1669)entity;
                evokerFangsEntity.method_7473(caster);
            }
            if (entity instanceof class_1634) {
                class_1634 vexEntity = (class_1634)entity;
                if (caster instanceof class_1308) {
                    class_1308 mobCaster = (class_1308)caster;
                    vexEntity.method_7178(mobCaster);
                }
            }
            SpellContext summonedContext = new SpellContext(context, entity);
            summonedContext.apply(this.effects);
        }
    }

    public MapCodec<SummonEntitySpellEffect> getCodec() {
        return MAP_CODEC;
    }

    private static void initializeShulkerBulletNbtCompound(class_2487 nbtCompound, SpellContext context) {
        class_1297 target = context.target();
        class_1309 caster = context.caster();
        if (target != null) {
            nbtCompound.method_67494("Target", class_4844.field_25122, (Object)target.method_5667());
        }
        class_2350 direction = RotationSource.getDirection(context);
        nbtCompound.method_68082("Dir", class_2350.field_57037, (Object)direction);
        nbtCompound.method_10569("Steps", 10 + caster.method_59922().method_43048(5) * 10);
        double xOffset = direction.method_10148();
        double yOffset = direction.method_10164();
        double zOffset = direction.method_10165();
        double distance = Math.sqrt(xOffset * xOffset + yOffset * yOffset + zOffset * zOffset);
        nbtCompound.method_10549("TXD", xOffset / distance * 0.15);
        nbtCompound.method_10549("TYD", yOffset / distance * 0.15);
        nbtCompound.method_10549("TZD", zOffset / distance * 0.15);
    }

    public static Builder builder(class_6880.class_6883<class_1299<?>> entityType) {
        return new Builder(entityType);
    }

    public static class Builder {
        private final List<class_6880.class_6883<class_1299<?>>> entityTypes = new ArrayList();
        private final List<SpellEffect> effects = new ArrayList<SpellEffect>();
        private class_2487 nbt = null;

        public Builder(class_6880.class_6883<class_1299<?>> entityType) {
            this.entityTypes.add(entityType);
        }

        public Builder addEntityType(class_6880.class_6883<class_1299<?>> entityType) {
            this.entityTypes.add(entityType);
            return this;
        }

        public Builder addEffect(SpellEffect effect) {
            this.effects.add(effect);
            return this;
        }

        public Builder nbt(class_2487 nbt) {
            this.nbt = nbt;
            return this;
        }

        public SummonEntitySpellEffect build() {
            return new SummonEntitySpellEffect((class_6885<class_1299<?>>)class_6885.method_40242(this.entityTypes), this.effects, Optional.ofNullable(this.nbt));
        }
    }
}

