/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.position;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContext;
import io.github.pistonpoek.magicalscepter.spell.position.PositionSource;
import io.github.pistonpoek.magicalscepter.spell.position.RelativePositionSource;
import io.github.pistonpoek.magicalscepter.spell.rotation.RotationSource;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

public record RandomPositionSource(double dx, double dy, double dz, Optional<PositionSource> position, Optional<RotationSource> rotation) implements PositionSource
{
    static MapCodec<RandomPositionSource> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("dx").forGetter(RandomPositionSource::dx), (App)Codec.DOUBLE.fieldOf("dy").forGetter(RandomPositionSource::dy), (App)Codec.DOUBLE.fieldOf("dz").forGetter(RandomPositionSource::dz), (App)PositionSource.CODEC.optionalFieldOf("position").forGetter(RandomPositionSource::position), (App)RotationSource.CODEC.optionalFieldOf("rotation").forGetter(RandomPositionSource::rotation)).apply((Applicative)instance, RandomPositionSource::new));

    @Override
    public class_243 getPosition(@NotNull SpellContext context) {
        class_5819 random = context.caster().method_59922();
        PositionSource position = this.getRandomPositionSource(random);
        return position.getPosition(context);
    }

    private PositionSource getRandomPositionSource(class_5819 random) {
        RelativePositionSource.Builder builder = RelativePositionSource.builder(random.method_43058() * this.dx, random.method_43058() * this.dy, random.method_43058() * this.dz);
        this.position.ifPresent(builder::position);
        this.rotation.ifPresent(builder::rotation);
        return builder.build();
    }

    @Override
    public MapCodec<? extends PositionSource> getCodec() {
        return MAP_CODEC;
    }

    public static Builder builder(double x, double y, double z) {
        return new Builder(x, y, z);
    }

    public static Builder builder(class_243 vector) {
        return new Builder(vector.field_1352, vector.field_1351, vector.field_1350);
    }

    public static class Builder {
        private final double x;
        private final double y;
        private final double z;
        private PositionSource position = null;
        private RotationSource rotation = null;

        public Builder(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Builder position(PositionSource position) {
            this.position = position;
            return this;
        }

        public Builder rotation(RotationSource rotation) {
            this.rotation = rotation;
            return this;
        }

        public RandomPositionSource build() {
            return new RandomPositionSource(this.x, this.y, this.z, Optional.ofNullable(this.position), Optional.ofNullable(this.rotation));
        }
    }
}

