/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.component;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.component.ModDataComponentTypes;
import io.github.pistonpoek.magicalscepter.scepter.Scepter;
import io.github.pistonpoek.magicalscepter.spell.Spell;
import io.github.pistonpoek.magicalscepter.util.ModIdentifier;
import io.github.pistonpoek.magicalscepter.util.PlayerExperience;
import java.util.Optional;
import java.util.function.Consumer;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_2561;
import net.minecraft.class_2564;
import net.minecraft.class_2583;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_6880;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;
import net.minecraft.class_9299;
import net.minecraft.class_9473;
import net.minecraft.class_9848;

public record ScepterContentsComponent(Optional<class_6880<Scepter>> scepter, Optional<Integer> customColor, Optional<Integer> customExperienceCost, Optional<Boolean> infusable, Optional<class_6880<Spell>> customAttackSpell, Optional<class_6880<Spell>> customProtectSpell) implements class_9299
{
    public static final ScepterContentsComponent DEFAULT = new ScepterContentsComponent(Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    public static final int BASE_COLOR = -4424612;
    public static final int BASE_EXPERIENCE_COST = 0;
    public static final Codec<ScepterContentsComponent> BASE_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)Scepter.ENTRY_CODEC.optionalFieldOf("scepter").forGetter(ScepterContentsComponent::scepter), (App)Codec.INT.optionalFieldOf("custom_color").forGetter(ScepterContentsComponent::customColor), (App)Codec.intRange((int)0, (int)Integer.MAX_VALUE).optionalFieldOf("custom_experience_cost").forGetter(ScepterContentsComponent::customExperienceCost), (App)Codec.BOOL.optionalFieldOf("infusable").forGetter(ScepterContentsComponent::infusable), (App)Spell.ENTRY_CODEC.optionalFieldOf("custom_attack_spell").forGetter(ScepterContentsComponent::customAttackSpell), (App)Spell.ENTRY_CODEC.optionalFieldOf("custom_protect_spell").forGetter(ScepterContentsComponent::customProtectSpell)).apply((Applicative)instance, ScepterContentsComponent::new));
    public static final Codec<ScepterContentsComponent> CODEC = Codec.withAlternative(BASE_CODEC, Scepter.ENTRY_CODEC, ScepterContentsComponent::new);
    public static final class_9139<class_9129, ScepterContentsComponent> PACKET_CODEC = class_9139.method_58025((class_9139)Scepter.ENTRY_PACKET_CODEC.method_56433(class_9135::method_56382), ScepterContentsComponent::scepter, (class_9139)class_9135.field_49675.method_56433(class_9135::method_56382), ScepterContentsComponent::customColor, (class_9139)class_9135.field_49675.method_56433(class_9135::method_56382), ScepterContentsComponent::customExperienceCost, (class_9139)class_9135.field_48547.method_56433(class_9135::method_56382), ScepterContentsComponent::infusable, (class_9139)Spell.ENTRY_PACKET_CODEC.method_56433(class_9135::method_56382), ScepterContentsComponent::customAttackSpell, (class_9139)Spell.ENTRY_PACKET_CODEC.method_56433(class_9135::method_56382), ScepterContentsComponent::customProtectSpell, ScepterContentsComponent::new);
    private static final class_124 ATTACK_SPELL_FORMATTING = class_124.field_1077;
    private static final class_124 PROTECT_SPELL_FORMATTING = class_124.field_1078;
    private static final class_2561 MISSING_SPELL_TEXT = ModIdentifier.translatable("scepter.missing_spell", new Object[0]).method_27692(class_124.field_1063);
    private static final class_124 TITLE_FORMATTING = class_124.field_1080;
    private static final class_2561 NO_SPELLS_TEXT = ModIdentifier.translatable("scepter.no_spells", new Object[0]).method_27692(TITLE_FORMATTING);
    private static final class_2561 CAST_ATTACK_TEXT = ModIdentifier.translatable("scepter.on_cast_attack", new Object[0]).method_27692(TITLE_FORMATTING);
    private static final class_2561 CAST_PROTECT_TEXT = ModIdentifier.translatable("scepter.on_cast_protect", new Object[0]).method_27692(TITLE_FORMATTING);

    public ScepterContentsComponent(class_6880<Scepter> scepter) {
        this(Optional.of(scepter), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty());
    }

    public static Optional<ScepterContentsComponent> get(class_1799 stack) {
        return Optional.ofNullable((ScepterContentsComponent)stack.method_58694(ModDataComponentTypes.SCEPTER_CONTENTS));
    }

    public static Optional<class_6880<Scepter>> getScepter(class_1799 stack) {
        return ScepterContentsComponent.get(stack).flatMap(ScepterContentsComponent::scepter);
    }

    private Optional<Scepter> getScepterValue() {
        return this.scepter.map(class_6880::comp_349);
    }

    public static class_1799 setScepter(class_1799 stack, class_6880<Scepter> scepter) {
        stack.method_57367(ModDataComponentTypes.SCEPTER_CONTENTS, (Object)DEFAULT, scepter, ScepterContentsComponent::with);
        return stack;
    }

    public int getColor(int defaultColor) {
        return this.customColor.orElseGet(() -> this.getScepterValue().map(Scepter::getColor).orElse(defaultColor));
    }

    public int getColor() {
        return this.customColor.or(() -> this.getScepterValue().map(Scepter::getColor)).map(class_9848::method_61334).orElse(-4424612);
    }

    public int getExperienceCost() {
        return this.customExperienceCost.or(() -> this.scepter.map(class_6880::comp_349).map(Scepter::getExperienceCost)).orElse(0);
    }

    public boolean hasEnoughExperience(class_1657 player) {
        return PlayerExperience.getTotalExperience(player) >= this.getExperienceCost();
    }

    public static boolean isInfusable(class_1799 stack) {
        return ScepterContentsComponent.get(stack).flatMap(ScepterContentsComponent::isInfusable).orElse(true);
    }

    public Optional<Boolean> isInfusable() {
        return this.infusable.or(() -> this.getScepterValue().map(Scepter::isInfusable));
    }

    public String getTranslationKey() {
        return this.scepter.flatMap(class_6880::method_40230).map(key -> key.method_29177().method_12832().replace("/", ".")).orElse("empty");
    }

    public static boolean hasSpell(class_1799 stack) {
        return ScepterContentsComponent.get(stack).map(ScepterContentsComponent::hasSpell).orElse(false);
    }

    public boolean hasSpell() {
        return this.customAttackSpell.isPresent() || this.customProtectSpell.isPresent() || this.getScepterValue().map(Scepter::getAttackSpell).isPresent() || this.getScepterValue().map(Scepter::getProtectSpell).isPresent();
    }

    public static Optional<Spell> getAttackSpell(class_1799 stack) {
        return ScepterContentsComponent.get(stack).flatMap(ScepterContentsComponent::getAttackSpell).map(class_6880::comp_349);
    }

    public Optional<class_6880<Spell>> getAttackSpell() {
        return this.customAttackSpell.or(() -> this.getScepterValue().flatMap(Scepter::getAttackSpell));
    }

    public static Optional<Spell> getProtectSpell(class_1799 stack) {
        return ScepterContentsComponent.get(stack).flatMap(ScepterContentsComponent::getProtectSpell).map(class_6880::comp_349);
    }

    public Optional<class_6880<Spell>> getProtectSpell() {
        return this.customProtectSpell.or(() -> this.getScepterValue().flatMap(Scepter::getProtectSpell));
    }

    public ScepterContentsComponent with(class_6880<Scepter> scepter) {
        return new ScepterContentsComponent(Optional.of(scepter), this.customColor, this.customExperienceCost, this.infusable, this.customAttackSpell, this.customProtectSpell);
    }

    public class_2561 getAttackSpellName() {
        Optional<class_6880<Spell>> attackSpell = this.getAttackSpell();
        if (attackSpell.isEmpty()) {
            return MISSING_SPELL_TEXT;
        }
        class_5250 mutableText = Spell.getName(attackSpell.get());
        return class_2564.method_10889((class_5250)mutableText, (class_2583)class_2583.field_24360.method_10977(ATTACK_SPELL_FORMATTING));
    }

    public class_2561 getProtectSpellName() {
        Optional<class_6880<Spell>> protectSpell = this.getProtectSpell();
        if (protectSpell.isEmpty()) {
            return MISSING_SPELL_TEXT;
        }
        class_5250 mutableText = Spell.getName(protectSpell.get());
        return class_2564.method_10889((class_5250)mutableText, (class_2583)class_2583.field_24360.method_10977(PROTECT_SPELL_FORMATTING));
    }

    public void method_57409(class_1792.class_9635 context, Consumer<class_2561> tooltip, class_1836 type, class_9473 components) {
        Optional<class_6880<Spell>> attackSpell = this.getAttackSpell();
        Optional<class_6880<Spell>> protectSpell = this.getProtectSpell();
        if (attackSpell.isEmpty() && protectSpell.isEmpty()) {
            tooltip.accept(NO_SPELLS_TEXT);
            return;
        }
        tooltip.accept(class_5244.field_39003);
        if (attackSpell.isPresent()) {
            tooltip.accept(CAST_ATTACK_TEXT);
            tooltip.accept((class_2561)class_5244.method_48320().method_10852(this.getAttackSpellName()));
        }
        if (protectSpell.isPresent()) {
            tooltip.accept(CAST_PROTECT_TEXT);
            tooltip.accept((class_2561)class_5244.method_48320().method_10852(this.getProtectSpellName()));
        }
    }
}

