/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.entity.ai.goal;

import io.github.pistonpoek.magicalscepter.component.ScepterContentsComponent;
import io.github.pistonpoek.magicalscepter.item.MagicalScepterItem;
import io.github.pistonpoek.magicalscepter.scepter.ScepterHelper;
import io.github.pistonpoek.magicalscepter.spell.Spell;
import io.github.pistonpoek.magicalscepter.util.LivingEntityHand;
import java.util.EnumSet;
import java.util.Optional;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1308;
import net.minecraft.class_1309;
import net.minecraft.class_1352;
import net.minecraft.class_1588;
import net.minecraft.class_1799;
import org.jetbrains.annotations.NotNull;

public class ScepterAttackGoal<T extends class_1588>
extends class_1352 {
    private static final double ATTACKS_PER_PROTECT = Math.E;
    private final T actor;
    private final double speed;
    private final int castInterval;
    private final int protectInterval;
    private final float squaredRange;
    private int cooldown = -1;
    private int targetSeeingTicker;

    public ScepterAttackGoal(T actor, double speed, int castInterval, float range) {
        this.actor = actor;
        this.speed = speed;
        this.castInterval = castInterval;
        this.protectInterval = (int)(3.718281828459045 * (double)this.castInterval);
        this.squaredRange = range * range;
        this.method_6265(EnumSet.of(class_1352.class_4134.field_18405, class_1352.class_4134.field_18406));
    }

    public boolean method_6264() {
        return this.hasAliveTarget() && this.isHoldingScepterWithSpell();
    }

    protected boolean isHoldingScepterWithSpell() {
        return this.actor.method_24520(ScepterHelper.IS_SCEPTER_WITH_SPELL);
    }

    private boolean hasAliveTarget() {
        return this.actor.method_5968() != null && this.actor.method_5968().method_5805();
    }

    public void method_6269() {
        super.method_6269();
        this.actor.method_19540(true);
        if (this.actor.method_5985().method_6369((class_1297)this.actor.method_5968())) {
            this.targetSeeingTicker = 15;
        }
    }

    public void method_6270() {
        super.method_6270();
        this.actor.method_19540(false);
        this.actor.method_5980(null);
        this.targetSeeingTicker = 0;
    }

    public boolean method_6267() {
        return this.cooldown >= 5 || this.targetSeeingTicker < 15;
    }

    public boolean method_38846() {
        return true;
    }

    public void method_6268() {
        Optional<Spell> scepterSpell;
        boolean isAttack;
        class_1309 target = this.actor.method_5968();
        if (target == null) {
            return;
        }
        this.updateTargetSeeingTicker(target);
        this.updateNavigation(target);
        this.updateLookControl(target);
        if (this.cooldown-- > 0 || this.targetSeeingTicker < 20) {
            return;
        }
        this.cooldown = this.castInterval;
        class_1268 hand = LivingEntityHand.get(this.actor, ScepterHelper.IS_SCEPTER_WITH_SPELL);
        class_1799 scepterStack = this.actor.method_5998(hand);
        Optional<Spell> attackSpell = ScepterContentsComponent.getAttackSpell(scepterStack);
        Optional<Spell> protectSpell = ScepterContentsComponent.getProtectSpell(scepterStack);
        if (this.useProtectSpell(target)) {
            isAttack = protectSpell.isEmpty();
            scepterSpell = protectSpell.or(() -> attackSpell);
        } else {
            isAttack = attackSpell.isPresent();
            scepterSpell = attackSpell.or(() -> protectSpell);
        }
        scepterSpell.ifPresent(spell -> {
            class_1799 usedScepterStack = MagicalScepterItem.castSpell(spell, this.actor, scepterStack, isAttack, class_1268.field_5808);
            this.actor.method_6122(hand, usedScepterStack);
        });
    }

    private boolean useProtectSpell(@NotNull class_1309 target) {
        boolean targetNearby = this.actor.method_5858((class_1297)target) < (double)(this.squaredRange * 0.3f);
        boolean recentlyDamaged = this.actor.method_6081() != null;
        boolean inProtectInterval = ((class_1588)this.actor).field_6012 % this.protectInterval < this.castInterval;
        return (targetNearby || recentlyDamaged) && inProtectInterval;
    }

    private void updateTargetSeeingTicker(@NotNull class_1309 target) {
        boolean targetAware;
        boolean targetVisible = this.actor.method_5985().method_6369((class_1297)target);
        boolean bl = targetAware = this.targetSeeingTicker > 0;
        if (targetVisible != targetAware) {
            this.targetSeeingTicker = 0;
        }
        this.targetSeeingTicker = targetVisible ? ++this.targetSeeingTicker : --this.targetSeeingTicker;
    }

    private void updateNavigation(@NotNull class_1309 target) {
        double squaredDistance = this.actor.method_5858((class_1297)target);
        if (squaredDistance <= (double)this.squaredRange && this.targetSeeingTicker >= 5) {
            this.actor.method_5942().method_6340();
        } else {
            this.actor.method_5942().method_6335((class_1297)target, this.speed);
        }
    }

    private void updateLookControl(@NotNull class_1309 target) {
        class_1297 class_12972 = this.actor.method_49694();
        if (class_12972 instanceof class_1308) {
            class_1308 mobEntity = (class_1308)class_12972;
            mobEntity.method_5951((class_1297)target, 30.0f, 30.0f);
            mobEntity.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
        }
        this.actor.method_5951((class_1297)target, 30.0f, 30.0f);
        this.actor.method_5988().method_6226((class_1297)target, 30.0f, 30.0f);
    }
}

