/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.scepter;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.registry.ModRegistryKeys;
import io.github.pistonpoek.magicalscepter.spell.Spell;
import java.util.Optional;
import net.minecraft.class_47;
import net.minecraft.class_5258;
import net.minecraft.class_5699;
import net.minecraft.class_6880;
import net.minecraft.class_6899;
import net.minecraft.class_9129;
import net.minecraft.class_9135;
import net.minecraft.class_9139;

public record Scepter(int color, int experienceCost, boolean infusable, Optional<class_6880<Spell>> attackSpell, Optional<class_6880<Spell>> protectSpell, Optional<class_5258> infusion) {
    public static final Codec<Scepter> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_54067.fieldOf("color").forGetter(Scepter::color), (App)class_5699.field_33441.fieldOf("experience_cost").forGetter(Scepter::experienceCost), (App)Codec.BOOL.optionalFieldOf("infusable", (Object)false).forGetter(Scepter::infusable), (App)Spell.ENTRY_CODEC.optionalFieldOf("spell_attack").forGetter(Scepter::attackSpell), (App)Spell.ENTRY_CODEC.optionalFieldOf("spell_protect").forGetter(Scepter::protectSpell), (App)class_5258.field_47234.optionalFieldOf("infusion").forGetter(Scepter::infusion)).apply((Applicative)instance, Scepter::new));
    public static final Codec<Scepter> NETWORK_CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_5699.field_54067.fieldOf("color").forGetter(Scepter::color), (App)class_5699.field_33441.fieldOf("experience_cost").forGetter(Scepter::experienceCost), (App)Codec.BOOL.optionalFieldOf("infusable", (Object)false).forGetter(Scepter::infusable), (App)Spell.ENTRY_CODEC.optionalFieldOf("spell_attack").forGetter(Scepter::attackSpell), (App)Spell.ENTRY_CODEC.optionalFieldOf("spell_protect").forGetter(Scepter::protectSpell)).apply((Applicative)instance, Scepter::createClientScepter));
    public static final Codec<class_6880<Scepter>> ENTRY_CODEC = class_6899.method_40400(ModRegistryKeys.SCEPTER);
    public static final class_9139<class_9129, class_6880<Scepter>> ENTRY_PACKET_CODEC = class_9135.method_56383(ModRegistryKeys.SCEPTER);
    public static final class_9139<class_9129, Scepter> PACKET_CODEC = class_9135.method_56896(CODEC);

    private static Scepter createClientScepter(int color, int experienceCost, boolean infusable, Optional<class_6880<Spell>> attackSpell, Optional<class_6880<Spell>> protectSpell) {
        return new Scepter(color, experienceCost, infusable, attackSpell, protectSpell, Optional.empty());
    }

    public int getColor() {
        return this.color;
    }

    public boolean isInfusable() {
        return this.infusable;
    }

    public int getExperienceCost() {
        return this.experienceCost;
    }

    public Optional<class_6880<Spell>> getAttackSpell() {
        return this.attackSpell;
    }

    public Optional<class_6880<Spell>> getProtectSpell() {
        return this.protectSpell;
    }

    public boolean infuses(class_47 lootContext) {
        if (this.infusion.isEmpty()) {
            return false;
        }
        class_5258 lootContextPredicate = this.infusion.get();
        return lootContextPredicate.method_27806(lootContext);
    }

    public static Builder builder(int color, int experienceCost, boolean infusable) {
        return new Builder(color, experienceCost, infusable);
    }

    public static class Builder {
        private final int color;
        private final boolean infusable;
        private final int experienceCost;
        private class_6880<Spell> attackSpell = null;
        private class_6880<Spell> protectSpell = null;
        private class_5258 infusion = null;

        public Builder(int color, int experienceCost, boolean infusable) {
            this.color = color;
            this.experienceCost = experienceCost;
            this.infusable = infusable;
        }

        public Builder infusion(class_5258 infusion) {
            this.infusion = infusion;
            return this;
        }

        public Builder attackSpell(class_6880<Spell> attackSpell) {
            this.attackSpell = attackSpell;
            return this;
        }

        public Builder protectSpell(class_6880<Spell> protectSpell) {
            this.protectSpell = protectSpell;
            return this;
        }

        public Scepter build() {
            return new Scepter(this.color, this.experienceCost, this.infusable, Optional.ofNullable(this.attackSpell), Optional.ofNullable(this.protectSpell), Optional.ofNullable(this.infusion));
        }
    }
}

