/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.scepter;

import io.github.pistonpoek.magicalscepter.component.ModDataComponentTypes;
import io.github.pistonpoek.magicalscepter.component.ScepterContentsComponent;
import io.github.pistonpoek.magicalscepter.component.ScepterExperienceComponent;
import io.github.pistonpoek.magicalscepter.item.ModItems;
import io.github.pistonpoek.magicalscepter.registry.ModRegistryKeys;
import io.github.pistonpoek.magicalscepter.scepter.Scepter;
import java.util.Optional;
import java.util.function.Predicate;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1937;
import net.minecraft.class_2378;
import net.minecraft.class_6880;

public class ScepterHelper {
    public static final Predicate<class_1799> IS_SCEPTER = itemStack -> itemStack.method_31574(ModItems.SCEPTER);
    public static final Predicate<class_1799> IS_ARCANE_SCEPTER = itemStack -> itemStack.method_31574(ModItems.ARCANE_SCEPTER);
    public static final Predicate<class_1799> IS_FILLED_ARCANE_SCEPTER = itemStack -> IS_ARCANE_SCEPTER.test((class_1799)itemStack) && ScepterHelper.getExperience(itemStack) >= 7;
    public static final Predicate<class_1799> IS_MAGICAL_SCEPTER = itemStack -> itemStack.method_31574(ModItems.MAGICAL_SCEPTER);
    public static final Predicate<class_1799> IS_INFUSABLE_SCEPTER = itemStack -> IS_MAGICAL_SCEPTER.test((class_1799)itemStack) && ScepterContentsComponent.isInfusable(itemStack);
    public static final Predicate<class_1799> IS_SCEPTER_WITH_SPELL = itemStack -> IS_MAGICAL_SCEPTER.test((class_1799)itemStack) && ScepterContentsComponent.hasSpell(itemStack);

    public static class_1799 createMagicalScepter(class_6880<Scepter> scepter) {
        return ScepterHelper.createMagicalScepter(class_1799.field_8037, scepter);
    }

    public static class_1799 createMagicalScepter(class_1799 stack, class_6880<Scepter> scepter) {
        class_1799 scepterStack = ModItems.MAGICAL_SCEPTER.method_7854();
        scepterStack.method_59692(stack.method_57380());
        return ScepterContentsComponent.setScepter(scepterStack, scepter);
    }

    public static class_1799 createScepter(class_1799 stack) {
        class_1799 scepterStack = ModItems.SCEPTER.method_7854();
        scepterStack.method_59692(stack.method_57380());
        scepterStack.method_57381(ModDataComponentTypes.SCEPTER_CONTENTS);
        return scepterStack;
    }

    public static class_2378<Scepter> getScepterRegistry(class_1937 world) {
        return world.method_30349().method_30530(ModRegistryKeys.SCEPTER);
    }

    public static Optional<ScepterContentsComponent> getScepterContentsComponent(class_1657 player) {
        if (IS_SCEPTER_WITH_SPELL.test(player.method_6047())) {
            return ScepterContentsComponent.get(player.method_6047());
        }
        if (IS_SCEPTER_WITH_SPELL.test(player.method_6079())) {
            return ScepterContentsComponent.get(player.method_6079());
        }
        return ScepterContentsComponent.get(player.method_6047()).or(() -> ScepterContentsComponent.get(player.method_6079()));
    }

    public static int getExperience(class_1799 itemStack) {
        return ((ScepterExperienceComponent)itemStack.method_58695(ModDataComponentTypes.SCEPTER_EXPERIENCE, (Object)ScepterExperienceComponent.DEFAULT)).experience();
    }
}

