/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.cast.transformer;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellCasting;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContext;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.CastTransformer;
import io.github.pistonpoek.magicalscepter.spell.cast.transformer.DelayCastTransformer;
import io.github.pistonpoek.magicalscepter.spell.position.AbsolutePositionSource;
import io.github.pistonpoek.magicalscepter.spell.position.PositionSource;
import io.github.pistonpoek.magicalscepter.spell.position.RelativePositionSource;
import io.github.pistonpoek.magicalscepter.spell.rotation.AbsoluteRotationSource;
import io.github.pistonpoek.magicalscepter.spell.rotation.FacingLocationRotationSource;
import java.util.ArrayList;
import java.util.Collection;
import net.minecraft.class_243;
import net.minecraft.class_3545;
import net.minecraft.class_5699;
import org.jetbrains.annotations.NotNull;

public record CircleCastTransformer(PositionSource position, float direction, float arc, int amount, float stepDelay) implements CastTransformer
{
    public static final MapCodec<CircleCastTransformer> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)PositionSource.CODEC.fieldOf("position").forGetter(CircleCastTransformer::position), (App)Codec.floatRange((float)180.0f, (float)-180.0f).optionalFieldOf("direction", (Object)Float.valueOf(0.0f)).forGetter(CircleCastTransformer::direction), (App)Codec.FLOAT.optionalFieldOf("arc", (Object)Float.valueOf(360.0f)).forGetter(CircleCastTransformer::arc), (App)class_5699.field_33441.fieldOf("amount").forGetter(CircleCastTransformer::amount), (App)class_5699.field_53754.optionalFieldOf("step_delay", (Object)Float.valueOf(0.0f)).forGetter(CircleCastTransformer::stepDelay)).apply((Applicative)instance, CircleCastTransformer::new));

    @Override
    public Collection<SpellCasting> transform(@NotNull SpellCasting casting) {
        SpellContext context = casting.getContext();
        FacingLocationRotationSource rotation = new FacingLocationRotationSource(this.position);
        class_243 centerPos = context.position();
        double radius = this.position.getPosition(context).method_1020(centerPos).method_1033();
        double x = Math.cos(Math.toRadians(this.direction));
        double y = Math.sin(Math.toRadians(this.direction));
        ArrayList<SpellCasting> casts = new ArrayList<SpellCasting>();
        double radianStep = Math.toRadians(this.arc) / (double)this.amount;
        for (int i = 0; i < this.amount; ++i) {
            SpellCasting pointCast = DelayCastTransformer.delay(casting, (int)((float)i * this.stepDelay));
            double angle = radianStep * (double)i;
            class_243 relativePosition = new class_243(x * Math.sin(angle), y * Math.sin(angle), Math.cos(angle)).method_1021(radius);
            AbsolutePositionSource absolutePosition = AbsolutePositionSource.builder(RelativePositionSource.builder(relativePosition).rotation(rotation).build().getPosition(context)).build();
            pointCast.addContext(absolutePosition);
            class_3545<Float, Float> pointRotation = new FacingLocationRotationSource(absolutePosition).getRotation(context);
            AbsoluteRotationSource absoluteRotation = new AbsoluteRotationSource(((Float)pointRotation.method_15442()).floatValue(), ((Float)pointRotation.method_15441()).floatValue());
            pointCast.addContext(absoluteRotation);
            casts.add(pointCast);
        }
        return casts;
    }

    public MapCodec<CircleCastTransformer> getCodec() {
        return MAP_CODEC;
    }

    public static Builder builder(PositionSource position, int amount) {
        return new Builder(position, amount);
    }

    public static class Builder {
        private final PositionSource position;
        private float direction = 0.0f;
        private float arc = 360.0f;
        private final int amount;
        private float stepDelay = 0.0f;

        public Builder(PositionSource position, int amount) {
            this.position = position;
            this.amount = amount;
        }

        public Builder direction(float direction) {
            this.direction = direction;
            return this;
        }

        public Builder arc(float arc) {
            this.arc = arc;
            return this;
        }

        public Builder stepDelay(float stepDelay) {
            this.stepDelay = stepDelay;
            return this;
        }

        public CircleCastTransformer build() {
            return new CircleCastTransformer(this.position, this.direction, this.arc, this.amount, this.stepDelay);
        }
    }
}

