/*
 * Decompiled with CFR 0.152.
 */
package io.github.pistonpoek.magicalscepter.spell.position;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import io.github.pistonpoek.magicalscepter.spell.cast.context.SpellContext;
import io.github.pistonpoek.magicalscepter.spell.position.PositionSource;
import io.github.pistonpoek.magicalscepter.spell.rotation.RotationSource;
import io.github.pistonpoek.magicalscepter.util.RotationVector;
import java.util.Optional;
import net.minecraft.class_243;
import net.minecraft.class_3532;
import org.jetbrains.annotations.NotNull;

public record RelativePositionSource(double x, double y, double z, Optional<PositionSource> position, Optional<RotationSource> rotation) implements PositionSource
{
    static MapCodec<RelativePositionSource> MAP_CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)Codec.DOUBLE.fieldOf("x").forGetter(RelativePositionSource::x), (App)Codec.DOUBLE.fieldOf("y").forGetter(RelativePositionSource::y), (App)Codec.DOUBLE.fieldOf("z").forGetter(RelativePositionSource::z), (App)PositionSource.CODEC.optionalFieldOf("position").forGetter(RelativePositionSource::position), (App)RotationSource.CODEC.optionalFieldOf("rotation").forGetter(RelativePositionSource::rotation)).apply((Applicative)instance, RelativePositionSource::new));

    @Override
    public class_243 getPosition(@NotNull SpellContext context) {
        class_243 vector = this.position.map(position -> position.getPosition(context)).orElse(context.position());
        float pitch = this.rotation.map(rotation -> Float.valueOf(rotation.getPitch(context))).orElse(Float.valueOf(context.pitch())).floatValue();
        float yaw = this.rotation.map(rotation -> Float.valueOf(rotation.getYaw(context))).orElse(Float.valueOf(context.yaw())).floatValue();
        return this.getRelativeVector(vector, pitch, yaw, this.x, this.y, this.z);
    }

    private class_243 getRelativeVector(class_243 base, float pitch, float yaw, double x, double y, double z) {
        return base.method_1019(RotationVector.get(0.0f, class_3532.method_15393((float)(yaw - 90.0f))).method_1029().method_1021(x)).method_1019(RotationVector.get(class_3532.method_15393((float)(pitch - 90.0f)), yaw).method_1029().method_1021(y)).method_1019(RotationVector.get(pitch, yaw).method_1029().method_1021(z));
    }

    public MapCodec<RelativePositionSource> getCodec() {
        return MAP_CODEC;
    }

    public static Builder builder(double x, double y, double z) {
        return new Builder(x, y, z);
    }

    public static Builder builder(class_243 vector) {
        return new Builder(vector.field_1352, vector.field_1351, vector.field_1350);
    }

    public static class Builder {
        private final double x;
        private final double y;
        private final double z;
        private PositionSource position = null;
        private RotationSource rotation = null;

        public Builder(double x, double y, double z) {
            this.x = x;
            this.y = y;
            this.z = z;
        }

        public Builder position(PositionSource position) {
            this.position = position;
            return this;
        }

        public Builder rotation(RotationSource rotation) {
            this.rotation = rotation;
            return this;
        }

        public RelativePositionSource build() {
            return new RelativePositionSource(this.x, this.y, this.z, Optional.ofNullable(this.position), Optional.ofNullable(this.rotation));
        }
    }
}

