/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.fabric;

import java.util.List;
import me.shedaniel.autoconfig.AutoConfig;
import me.shedaniel.autoconfig.ConfigData;
import me.shedaniel.autoconfig.annotation.Config;
import me.shedaniel.autoconfig.annotation.ConfigEntry;
import me.shedaniel.autoconfig.serializer.ConfigSerializer;
import me.shedaniel.autoconfig.serializer.JanksonConfigSerializer;
import me.shedaniel.autoconfig.serializer.PartitioningSerializer;
import net.minecraft.class_2960;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.config.HexalConfig;
import ram.talia.hexal.xplat.IXplatAbstractions;

@Config(name="hexal")
@Config.Gui.Background(value="minecraft:textures/block/calcite.png")
public class FabricHexalConfig
extends PartitioningSerializer.GlobalData {
    @ConfigEntry.Category(value="common")
    @ConfigEntry.Gui.TransitiveObject
    public final Common common = new Common();
    @ConfigEntry.Category(value="client")
    @ConfigEntry.Gui.TransitiveObject
    public final Client client = new Client();
    @ConfigEntry.Category(value="server")
    @ConfigEntry.Gui.TransitiveObject
    public final Server server = new Server();

    public static FabricHexalConfig setup() {
        AutoConfig.register(FabricHexalConfig.class, (ConfigSerializer.Factory)PartitioningSerializer.wrap(JanksonConfigSerializer::new));
        FabricHexalConfig instance = (FabricHexalConfig)AutoConfig.getConfigHolder(FabricHexalConfig.class).getConfig();
        HexalConfig.setCommon(instance.common);
        if (IXplatAbstractions.INSTANCE.isPhysicalClient()) {
            HexalConfig.setClient(instance.client);
        }
        HexalConfig.setServer(instance.server);
        return instance;
    }

    @Config(name="common")
    private static class Common
    implements ConfigData,
    HexalConfig.CommonConfigAccess {
        private Common() {
        }
    }

    @Config(name="client")
    private static class Client
    implements ConfigData,
    HexalConfig.ClientConfigAccess {
        @ConfigEntry.Gui.CollapsibleObject
        private MiscValues miscValues = new MiscValues();

        private Client() {
        }

        @Override
        public long getEverbookSaveDelay() {
            return Math.max(1L, this.miscValues.everbookSaveDelay);
        }

        static class MiscValues {
            long everbookSaveDelay = 200L;

            MiscValues() {
            }
        }
    }

    @Config(name="server")
    private static class Server
    implements ConfigData,
    HexalConfig.ServerConfigAccess {
        private boolean generateSlipwayGeodes = true;
        private long everbookMaxSize = 67108800L;
        @ConfigEntry.Gui.CollapsibleObject
        private MiscSpells miscSpells = new MiscSpells();
        @ConfigEntry.Gui.CollapsibleObject
        private FabricOnlySpells fabricOnlySpells = new FabricOnlySpells();
        @ConfigEntry.Gui.CollapsibleObject
        private WispSpells wispSpells = new WispSpells();
        @ConfigEntry.Gui.CollapsibleObject
        private WispUpkeep wispUpkeep = new WispUpkeep();
        @ConfigEntry.Gui.CollapsibleObject
        private LinkSpells linkSpells = new LinkSpells();
        @ConfigEntry.Gui.CollapsibleObject
        private GateSpells gateSpells = new GateSpells();
        @ConfigEntry.Gui.CollapsibleObject
        private ItemSpells itemSpells = new ItemSpells();
        @ConfigEntry.Gui.CollapsibleObject
        private GreatSpells greatSpells = new GreatSpells();

        private Server() {
        }

        public void validatePostLoad() throws ConfigData.ValidationException {
            this.everbookMaxSize = this.bound(this.everbookMaxSize, 0L, 0xFFFFF0000L);
            this.miscSpells.fallingBlockCost = this.bound(this.miscSpells.fallingBlockCost, 1.0E-4, 10000.0);
            this.miscSpells.freezeCost = this.bound(this.miscSpells.freezeCost, 1.0E-4, 10000.0);
            this.miscSpells.particlesCost = this.bound(this.miscSpells.particlesCost, 1.0E-4, 10000.0);
            this.miscSpells.placeTypeCost = this.bound(this.miscSpells.placeTypeCost, 1.0E-4, 10000.0);
            this.miscSpells.smeltCost = this.bound(this.miscSpells.smeltCost, 1.0E-4, 10000.0);
            this.fabricOnlySpells.phaseBlockCostFactor = this.bound(this.fabricOnlySpells.phaseBlockCostFactor, 1.0E-5, 0.001);
            this.wispSpells.moveSpeedSetCost = this.bound(this.wispSpells.moveSpeedSetCost, 1.0E-4, 10000.0);
            this.wispSpells.summonTickingWispCost = this.bound(this.wispSpells.summonTickingWispCost, 1.0E-4, 10000.0);
            this.wispSpells.summonProjectileWispCost = this.bound(this.wispSpells.summonProjectileWispCost, 1.0E-4, 10000.0);
            this.wispSpells.summonProjectileWispMinCost = this.bound(this.wispSpells.summonProjectileWispMinCost, 1.0E-4, 10000.0);
            this.wispUpkeep.tickingWispUpkeepPerTick = this.bound(this.wispUpkeep.tickingWispUpkeepPerTick, 1.0E-4, 10000.0);
            this.wispUpkeep.projectileWispUpkeepPerTick = this.bound(this.wispUpkeep.projectileWispUpkeepPerTick, 1.0E-4, 10000.0);
            this.wispUpkeep.untriggeredWispUpkeepDiscount = this.bound(this.wispUpkeep.untriggeredWispUpkeepDiscount, 0.0, 1.0);
            this.wispUpkeep.linkUpkeepPerTick = this.bound(this.wispUpkeep.linkUpkeepPerTick, 1.0E-4, 10000.0);
            this.wispUpkeep.seonDiscountFactor = this.bound(this.wispUpkeep.seonDiscountFactor, 2.0, 200.0);
            this.wispUpkeep.storingPlayerCostScaleFactor = this.bound(this.wispUpkeep.storingPlayerCostScaleFactor, 1.0, 200.0);
            this.wispUpkeep.mediaFlowRateOverLink = this.bound(this.wispUpkeep.mediaFlowRateOverLink, 0.0, 0.1);
            this.linkSpells.linkCost = this.bound(this.linkSpells.linkCost, 1.0E-4, 10000.0);
            this.linkSpells.sendIotaCost = this.bound(this.linkSpells.sendIotaCost, 1.0E-4, 10000.0);
            this.linkSpells.unlinkCost = this.bound(this.linkSpells.unlinkCost, 1.0E-4, 10000.0);
            this.gateSpells.makeGateCost = this.bound(this.gateSpells.makeGateCost, 1.0E-4, 10000.0);
            this.gateSpells.markGateCost = this.bound(this.gateSpells.markGateCost, 1.0E-4, 10000.0);
            this.gateSpells.closeGateCost = this.bound(this.gateSpells.closeGateCost, 1.0E-4, 10000.0);
            this.gateSpells.closeGateDistanceCostFactor = this.bound(this.gateSpells.closeGateDistanceCostFactor, 1.0E-4, 10000.0);
            this.gateSpells.maxGateOffset = this.bound(this.gateSpells.maxGateOffset, 1.0, 96.0);
            this.itemSpells.bindStorageCost = this.bound(this.itemSpells.bindStorageCost, 1.0E-4, 10000.0);
            this.itemSpells.bindTemporaryStorageCost = this.bound(this.itemSpells.bindTemporaryStorageCost, 1.0E-4, 10000.0);
            this.itemSpells.makeItemCost = this.bound(this.itemSpells.makeItemCost, 1.0E-4, 10000.0);
            this.itemSpells.returnItemCost = this.bound(this.itemSpells.returnItemCost, 1.0E-4, 10000.0);
            this.itemSpells.craftItemCost = this.bound(this.itemSpells.craftItemCost, 1.0E-4, 10000.0);
            this.itemSpells.tradeItemCost = this.bound(this.itemSpells.tradeItemCost, 1.0E-4, 10000.0);
            this.itemSpells.useItemOnCost = this.bound(this.itemSpells.useItemOnCost, 1.0E-4, 10000.0);
            this.itemSpells.maxItemsReturned = this.bound(this.itemSpells.maxItemsReturned, 640, 64000);
            this.itemSpells.maxRecordsInMediafiedStorage = this.bound(this.itemSpells.maxRecordsInMediafiedStorage, 128, 16384);
            this.greatSpells.consumeWispOwnCost = this.bound(this.greatSpells.consumeWispOwnCost, 1.0E-4, 10000.0);
            this.greatSpells.consumeWispOthersCostPerMedia = this.bound(this.greatSpells.consumeWispOthersCostPerMedia, 1.0, 20.0);
            this.greatSpells.seonWispSetCost = this.bound(this.greatSpells.seonWispSetCost, 1.0E-4, 10000.0);
            this.greatSpells.tickConstantCost = this.bound(this.greatSpells.tickConstantCost, 1.0E-4, 10000.0);
            this.greatSpells.tickCostPerTicked = this.bound(this.greatSpells.tickCostPerTicked, 1.0E-4, 10000.0);
            this.greatSpells.tickRandomTickIProb = this.bound(this.greatSpells.tickRandomTickIProb, 600, 2100);
            if (this.greatSpells.accelerateDenyList.stream().anyMatch(b -> !Server.isValidReslocArg(b))) {
                this.greatSpells.accelerateDenyList = HexalConfig.ServerConfigAccess.Companion.getDEFAULT_ACCELERATE_DENY_LIST();
            }
        }

        private int bound(int toBind, int lower, int upper) {
            return Math.min(Math.max(toBind, lower), upper);
        }

        private long bound(long toBind, long lower, long upper) {
            return Math.min(Math.max(toBind, lower), upper);
        }

        private double bound(double toBind, double lower, double upper) {
            return Math.min(Math.max(toBind, lower), upper);
        }

        private static boolean isValidReslocArg(Object o) {
            String s;
            return o instanceof String && class_2960.method_20207((String)(s = (String)o));
        }

        @Override
        public boolean getGenerateSlipwayGeodes() {
            return this.generateSlipwayGeodes;
        }

        @Override
        public long getEverbookMaxSize() {
            return this.everbookMaxSize;
        }

        @Override
        public long getFallingBlockCost() {
            return (long)(this.miscSpells.fallingBlockCost * 10000.0);
        }

        @Override
        public long getFreezeCost() {
            return (long)(this.miscSpells.freezeCost * 10000.0);
        }

        @Override
        public long getParticlesCost() {
            return (long)(this.miscSpells.particlesCost * 10000.0);
        }

        @Override
        public long getPlaceTypeCost() {
            return (long)(this.miscSpells.placeTypeCost * 10000.0);
        }

        @Override
        public double getPhaseBlockCostFactor() {
            return this.fabricOnlySpells.phaseBlockCostFactor * 10000.0;
        }

        @Override
        public long getSmeltCost() {
            return (long)(this.miscSpells.smeltCost * 10000.0);
        }

        @Override
        public long getMoveSpeedSetCost() {
            return (long)(this.wispSpells.moveSpeedSetCost * 10000.0);
        }

        @Override
        public long getSummonTickingWispCost() {
            return (long)(this.wispSpells.summonTickingWispCost * 10000.0);
        }

        @Override
        public long getSummonProjectileWispCost() {
            return (long)(this.wispSpells.summonProjectileWispCost * 10000.0);
        }

        @Override
        public long getSummonProjectileWispMinCost() {
            return (long)(this.wispSpells.summonProjectileWispMinCost * 10000.0);
        }

        @Override
        public long getTickingWispUpkeepPerTick() {
            return (long)(this.wispUpkeep.tickingWispUpkeepPerTick * 10000.0);
        }

        @Override
        public long getProjectileWispUpkeepPerTick() {
            return (long)(this.wispUpkeep.projectileWispUpkeepPerTick * 10000.0);
        }

        @Override
        public double getUntriggeredWispUpkeepDiscount() {
            return this.wispUpkeep.untriggeredWispUpkeepDiscount;
        }

        @Override
        public long getLinkUpkeepPerTick() {
            return (long)(this.wispUpkeep.linkUpkeepPerTick * 10000.0);
        }

        @Override
        public double getSeonDiscountFactor() {
            return this.wispUpkeep.seonDiscountFactor;
        }

        @Override
        public double getStoringPlayerCostScaleFactor() {
            return this.wispUpkeep.storingPlayerCostScaleFactor;
        }

        @Override
        public double getMediaFlowRateOverLink() {
            return this.wispUpkeep.mediaFlowRateOverLink;
        }

        @Override
        public long getLinkCost() {
            return (long)(this.linkSpells.linkCost * 10000.0);
        }

        @Override
        public long getSendIotaCost() {
            return (long)(this.linkSpells.sendIotaCost * 10000.0);
        }

        @Override
        public long getUnlinkCost() {
            return (long)(this.linkSpells.unlinkCost * 10000.0);
        }

        @Override
        public long getMakeGateCost() {
            return (long)(this.gateSpells.makeGateCost * 10000.0);
        }

        @Override
        public long getMarkGateCost() {
            return (long)(this.gateSpells.markGateCost * 10000.0);
        }

        @Override
        public long getCloseGateCost() {
            return (long)(this.gateSpells.closeGateCost * 10000.0);
        }

        @Override
        public long getCloseGateDistanceCostFactor() {
            return (long)(this.gateSpells.closeGateDistanceCostFactor * 10000.0);
        }

        @Override
        public double getMaxGateOffset() {
            return this.gateSpells.maxGateOffset;
        }

        @Override
        public long getBindStorageCost() {
            return (long)(this.itemSpells.bindStorageCost * 10000.0);
        }

        @Override
        public long getBindTemporaryStorageCost() {
            return (long)(this.itemSpells.bindTemporaryStorageCost * 10000.0);
        }

        @Override
        public long getMakeItemCost() {
            return (long)(this.itemSpells.makeItemCost * 10000.0);
        }

        @Override
        public long getReturnItemCost() {
            return (long)(this.itemSpells.returnItemCost * 10000.0);
        }

        @Override
        public long getCraftItemCost() {
            return (long)(this.itemSpells.craftItemCost * 10000.0);
        }

        @Override
        public long getTradeItemCost() {
            return (long)(this.itemSpells.tradeItemCost * 10000.0);
        }

        @Override
        public long getUseItemOnCost() {
            return (long)(this.itemSpells.useItemOnCost * 10000.0);
        }

        @Override
        public int getMaxItemsReturned() {
            return this.itemSpells.maxItemsReturned;
        }

        @Override
        public int getMaxRecordsInMediafiedStorage() {
            return this.itemSpells.maxRecordsInMediafiedStorage;
        }

        @Override
        public long getConsumeWispOwnCost() {
            return (long)(this.greatSpells.consumeWispOwnCost * 10000.0);
        }

        @Override
        public double getConsumeWispOthersCostPerMedia() {
            return this.greatSpells.consumeWispOthersCostPerMedia;
        }

        @Override
        public long getSeonWispSetCost() {
            return (long)(this.greatSpells.seonWispSetCost * 10000.0);
        }

        @Override
        public long getTickConstantCost() {
            return (long)(this.greatSpells.tickConstantCost * 10000.0);
        }

        @Override
        public long getTickCostPerTicked() {
            return (long)(this.greatSpells.tickCostPerTicked * 10000.0);
        }

        @Override
        public int getTickRandomTickIProb() {
            return this.greatSpells.tickRandomTickIProb;
        }

        @Override
        public boolean isAccelerateAllowed(@NotNull class_2960 blockId) {
            return HexalConfig.noneMatch(this.greatSpells.accelerateDenyList, blockId);
        }

        static class MiscSpells {
            double fallingBlockCost = 1.5;
            double freezeCost = 1.0;
            double particlesCost = 0.002;
            double placeTypeCost = 0.125;
            double smeltCost = 0.75;

            MiscSpells() {
            }
        }

        static class FabricOnlySpells {
            double phaseBlockCostFactor = 1.0E-4;

            FabricOnlySpells() {
            }
        }

        static class WispSpells {
            @ConfigEntry.Gui.Tooltip(count=2)
            double moveSpeedSetCost = 1.0;
            double summonTickingWispCost = 3.0;
            double summonProjectileWispCost = 1.7;
            double summonProjectileWispMinCost = 0.5;

            WispSpells() {
            }
        }

        static class WispUpkeep {
            double tickingWispUpkeepPerTick = 0.0325;
            double projectileWispUpkeepPerTick = 0.01625;
            @ConfigEntry.Gui.Tooltip(count=2)
            double untriggeredWispUpkeepDiscount = 0.77;
            double linkUpkeepPerTick = 5.0E-4;
            @ConfigEntry.Gui.Tooltip(count=2)
            double seonDiscountFactor = 20.0;
            @ConfigEntry.Gui.Tooltip(count=2)
            public double storingPlayerCostScaleFactor = 20.0;
            @ConfigEntry.Gui.Tooltip(count=2)
            public double mediaFlowRateOverLink = 0.01;

            WispUpkeep() {
            }
        }

        static class LinkSpells {
            double linkCost = 5.0;
            double sendIotaCost = 0.01;
            double unlinkCost = 2.0;

            LinkSpells() {
            }
        }

        static class GateSpells {
            double makeGateCost = 320.0;
            double markGateCost = 0.05;
            double closeGateCost = 2.5;
            double closeGateDistanceCostFactor = 0.1;
            double maxGateOffset = 32.0;

            GateSpells() {
            }
        }

        static class ItemSpells {
            double bindStorageCost = 32.0;
            double bindTemporaryStorageCost = 0.001;
            double makeItemCost = 0.1;
            double returnItemCost = 0.1;
            double craftItemCost = 0.1;
            double tradeItemCost = 0.1;
            double useItemOnCost = 0.125;
            @ConfigEntry.BoundedDiscrete(min=640L, max=64000L)
            @ConfigEntry.Gui.Tooltip(count=2)
            int maxItemsReturned = 32000;
            @ConfigEntry.BoundedDiscrete(min=128L, max=16384L)
            @ConfigEntry.Gui.Tooltip(count=2)
            int maxRecordsInMediafiedStorage = 1023;

            ItemSpells() {
            }
        }

        static class GreatSpells {
            @ConfigEntry.Gui.Tooltip(count=2)
            double consumeWispOwnCost = 5.0;
            @ConfigEntry.Gui.Tooltip(count=3)
            double consumeWispOthersCostPerMedia = 1.5;
            double seonWispSetCost = 50.0;
            @ConfigEntry.Gui.Tooltip
            double tickConstantCost = 0.1;
            @ConfigEntry.Gui.Tooltip(count=2)
            double tickCostPerTicked = 0.001;
            @ConfigEntry.BoundedDiscrete(min=600L, max=2100L)
            @ConfigEntry.Gui.Tooltip(count=3)
            int tickRandomTickIProb = 1365;
            @ConfigEntry.Gui.Tooltip
            private List<String> accelerateDenyList = HexalConfig.ServerConfigAccess.Companion.getDEFAULT_ACCELERATE_DENY_LIST();

            GreatSpells() {
            }
        }
    }
}

