/*
 * Decompiled with CFR 0.152.
 */
package ram.talia.hexal.common.lib;

import at.petrak.hexcasting.common.lib.HexSounds;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.function.BiConsumer;
import java.util.function.Supplier;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2382;
import net.minecraft.class_2405;
import net.minecraft.class_243;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_7403;
import net.minecraft.class_7784;
import org.jetbrains.annotations.NotNull;
import ram.talia.hexal.api.HexalAPI;

public class HexalSounds {
    private static final Map<class_2960, SoundEntry> SOUNDS = new LinkedHashMap<class_2960, SoundEntry>();
    public static final SoundEntry WISP_CASTING_START = HexalSounds.create("wisp_casting_start").subtitle("Wisp starts casting").playExisting(HexSounds.CAST_NORMAL, 0.5f, 1.0f).category(class_3419.field_15248).attenuationDistance(8).build();
    public static final SoundEntry WISP_CASTING_CONTINUE = HexalSounds.create("wisp_casting_continue").subtitle("Wisp continues casting").category(class_3419.field_15248).volume(0.5f).attenuationDistance(8).build();

    public static void registerSounds(BiConsumer<class_3414, class_2960> r) {
        for (Map.Entry<class_2960, SoundEntry> e : SOUNDS.entrySet()) {
            e.getValue().register(r);
        }
    }

    public static SoundEntryBuilder create(String id) {
        return HexalSounds.create(HexalAPI.modLoc(id));
    }

    public static SoundEntryBuilder create(class_2960 id) {
        return new SoundEntryBuilder(id);
    }

    public static JsonObject provideLangEntries() {
        JsonObject object = new JsonObject();
        for (SoundEntry entry : SOUNDS.values()) {
            if (!entry.hasSubtitle()) continue;
            object.addProperty(entry.getSubtitleKey(), entry.getSubtitle());
        }
        return object;
    }

    public static SoundEntryProvider provider(class_7784 output) {
        return new SoundEntryProvider(output);
    }

    public static abstract class SoundEntry {
        protected class_2960 id;
        protected String subtitle;
        protected class_3419 category;
        protected int attenuationDistance;

        public SoundEntry(class_2960 id, String subtitle, class_3419 category, int attenuationDistance) {
            this.id = id;
            this.subtitle = subtitle;
            this.category = category;
            this.attenuationDistance = attenuationDistance;
        }

        public abstract void register(BiConsumer<class_3414, class_2960> var1);

        public abstract void write(JsonObject var1);

        public abstract class_3414 getMainEvent();

        public String getSubtitleKey() {
            return this.id.method_12836() + ".subtitle." + this.id.method_12832();
        }

        public class_2960 getId() {
            return this.id;
        }

        public boolean hasSubtitle() {
            return this.subtitle != null;
        }

        public String getSubtitle() {
            return this.subtitle;
        }

        public class_3419 getCategory() {
            return this.category;
        }

        public void playOnServer(class_1937 world, class_2382 pos2) {
            this.playOnServer(world, pos2, 1.0f, 1.0f);
        }

        public void playOnServer(class_1937 world, class_2382 pos2, float volume, float pitch) {
            this.play(world, null, pos2, volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_2382 pos2) {
            this.play(world, entity, pos2, 1.0f, 1.0f);
        }

        public void playFrom(class_1297 entity) {
            this.playFrom(entity, 1.0f, 1.0f);
        }

        public void playFrom(class_1297 entity, float volume, float pitch) {
            if (!entity.method_5701()) {
                this.play(entity.method_37908(), null, (class_2382)entity.method_24515(), volume, pitch);
            }
        }

        public void play(class_1937 world, class_1657 entity, class_2382 pos2, float volume, float pitch) {
            this.play(world, entity, (double)pos2.method_10263() + 0.5, (double)pos2.method_10264() + 0.5, (double)pos2.method_10260() + 0.5, volume, pitch);
        }

        public void play(class_1937 world, class_1657 entity, class_243 pos2, float volume, float pitch) {
            this.play(world, entity, pos2.method_10216(), pos2.method_10214(), pos2.method_10215(), volume, pitch);
        }

        public abstract void play(class_1937 var1, class_1657 var2, double var3, double var5, double var7, float var9, float var10);

        public void playAt(class_1937 world, class_2382 pos2, float volume, float pitch, boolean fade) {
            this.playAt(world, (double)pos2.method_10263() + 0.5, (double)pos2.method_10264() + 0.5, (double)pos2.method_10260() + 0.5, volume, pitch, fade);
        }

        public void playAt(class_1937 world, class_243 pos2, float volume, float pitch, boolean fade) {
            this.playAt(world, pos2.method_10216(), pos2.method_10214(), pos2.method_10215(), volume, pitch, fade);
        }

        public abstract void playAt(class_1937 var1, double var2, double var4, double var6, float var8, float var9, boolean var10);
    }

    public static class SoundEntryBuilder {
        protected class_2960 id;
        protected String subtitle = "unregistered";
        protected class_3419 category = class_3419.field_15245;
        protected List<ConfiguredSoundEvent> wrappedEvents = new ArrayList<ConfiguredSoundEvent>();
        protected List<class_2960> variants = new ArrayList<class_2960>();
        protected float volume;
        protected float pitch;
        protected int attenuationDistance;

        public SoundEntryBuilder(class_2960 id) {
            this.id = id;
        }

        public SoundEntryBuilder subtitle(String subtitle) {
            this.subtitle = subtitle;
            return this;
        }

        public SoundEntryBuilder volume(float volume) {
            this.volume = volume;
            return this;
        }

        public SoundEntryBuilder pitch(float pitch) {
            this.pitch = pitch;
            return this;
        }

        public SoundEntryBuilder attenuationDistance(int distance) {
            this.attenuationDistance = distance;
            return this;
        }

        public SoundEntryBuilder noSubtitle() {
            this.subtitle = null;
            return this;
        }

        public SoundEntryBuilder category(class_3419 category) {
            this.category = category;
            return this;
        }

        public SoundEntryBuilder addVariant(String name) {
            return this.addVariant(HexalAPI.modLoc(name));
        }

        public SoundEntryBuilder addVariant(class_2960 id) {
            this.variants.add(id);
            return this;
        }

        public SoundEntryBuilder playExisting(Supplier<class_3414> event, float volume, float pitch) {
            this.wrappedEvents.add(new ConfiguredSoundEvent(event, volume, pitch));
            return this;
        }

        public SoundEntryBuilder playExisting(class_3414 event, float volume, float pitch) {
            return this.playExisting(() -> event, volume, pitch);
        }

        public SoundEntryBuilder playExisting(class_3414 event) {
            return this.playExisting(event, 1.0f, 1.0f);
        }

        public SoundEntry build() {
            SoundEntry entry = this.wrappedEvents.isEmpty() ? new CustomSoundEntry(this.id, this.variants, this.subtitle, this.category, this.volume, this.pitch, this.attenuationDistance) : new WrappedSoundEntry(this.id, this.subtitle, this.wrappedEvents, this.category, this.attenuationDistance);
            SOUNDS.put(entry.getId(), entry);
            return entry;
        }
    }

    public record SoundEntryProvider(class_7784 output) implements class_2405
    {
        public CompletableFuture<?> method_10319(@NotNull class_7403 cache) {
            return this.generate(this.output.method_45971(), cache);
        }

        @NotNull
        public String method_10321() {
            return "Hexal's Custom Sounds";
        }

        public CompletableFuture<?> generate(Path path, class_7403 cache) {
            path = path.resolve("assets/hexal");
            JsonObject json = new JsonObject();
            SOUNDS.entrySet().stream().sorted(Map.Entry.comparingByKey()).forEach(entry -> ((SoundEntry)entry.getValue()).write(json));
            return class_2405.method_10320((class_7403)cache, (JsonElement)json, (Path)path.resolve("sounds.json"));
        }
    }

    private static class CustomSoundEntry
    extends SoundEntry {
        protected List<class_2960> variants;
        protected class_3414 event;
        protected final float volume;
        protected final float pitch;

        public CustomSoundEntry(class_2960 id, List<class_2960> variants, String subtitle, class_3419 category, float volume, float pitch, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.event = class_3414.method_47908((class_2960)id);
            this.variants = variants;
            this.volume = volume;
            this.pitch = pitch;
        }

        @Override
        public void register(BiConsumer<class_3414, class_2960> registry) {
            registry.accept(this.event, this.id);
        }

        @Override
        public class_3414 getMainEvent() {
            return this.event;
        }

        @Override
        public void write(JsonObject json) {
            JsonObject entry = new JsonObject();
            JsonArray list = new JsonArray();
            JsonObject s = new JsonObject();
            s.addProperty("name", this.id.toString());
            s.addProperty("type", "file");
            if (this.volume != 0.0f) {
                s.addProperty("volume", (Number)Float.valueOf(this.volume));
            }
            if (this.pitch != 0.0f) {
                s.addProperty("pitch", (Number)Float.valueOf(this.pitch));
            }
            if (this.attenuationDistance != 0) {
                s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
            }
            list.add((JsonElement)s);
            for (class_2960 variant : this.variants) {
                s = new JsonObject();
                s.addProperty("name", variant.toString());
                s.addProperty("type", "file");
                if (this.volume != 0.0f) {
                    s.addProperty("volume", (Number)Float.valueOf(this.volume));
                }
                if (this.pitch != 0.0f) {
                    s.addProperty("pitch", (Number)Float.valueOf(this.pitch));
                }
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
            }
            entry.add("sounds", (JsonElement)list);
            if (this.hasSubtitle()) {
                entry.addProperty("subtitle", this.getSubtitleKey());
            }
            json.add(this.id.method_12832(), (JsonElement)entry);
        }

        @Override
        public void play(class_1937 world, class_1657 entity, double x, double y, double z, float volume, float pitch) {
            world.method_43128(entity, x, y, z, this.event, this.category, volume, pitch);
        }

        @Override
        public void playAt(class_1937 world, double x, double y, double z, float volume, float pitch, boolean fade) {
            world.method_8486(x, y, z, this.event, this.category, volume, pitch, fade);
        }
    }

    private static class WrappedSoundEntry
    extends SoundEntry {
        private final List<ConfiguredSoundEvent> wrappedEvents;

        public WrappedSoundEntry(class_2960 id, String subtitle, List<ConfiguredSoundEvent> wrappedEvents, class_3419 category, int attenuationDistance) {
            super(id, subtitle, category, attenuationDistance);
            this.wrappedEvents = wrappedEvents;
        }

        @Override
        public void register(BiConsumer<class_3414, class_2960> registry) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent wrapped = this.wrappedEvents.get(i);
                class_2960 location = this.getIdOf(i);
                registry.accept(class_3414.method_47908((class_2960)location), location);
            }
        }

        @Override
        public class_3414 getMainEvent() {
            return this.wrappedEvents.get(0).event().get();
        }

        protected class_2960 getIdOf(int i) {
            return new class_2960(this.id.method_12836(), (String)(i == 0 ? this.id.method_12832() : this.id.method_12832() + "_compounded_" + i));
        }

        @Override
        public void write(JsonObject json) {
            for (int i = 0; i < this.wrappedEvents.size(); ++i) {
                ConfiguredSoundEvent event = this.wrappedEvents.get(i);
                JsonObject entry = new JsonObject();
                JsonArray list = new JsonArray();
                JsonObject s = new JsonObject();
                s.addProperty("name", event.event().get().method_14833().toString());
                s.addProperty("type", "event");
                if (this.attenuationDistance != 0) {
                    s.addProperty("attenuation_distance", (Number)this.attenuationDistance);
                }
                list.add((JsonElement)s);
                entry.add("sounds", (JsonElement)list);
                if (i == 0 && this.hasSubtitle()) {
                    entry.addProperty("subtitle", this.getSubtitleKey());
                }
                json.add(this.getIdOf(i).method_12832(), (JsonElement)entry);
            }
        }

        @Override
        public void play(class_1937 world, class_1657 entity, double x, double y, double z, float volume, float pitch) {
            for (ConfiguredSoundEvent event : this.wrappedEvents) {
                world.method_43128(entity, x, y, z, event.event().get(), this.category, event.volume() * volume, event.pitch() * pitch);
            }
        }

        @Override
        public void playAt(class_1937 world, double x, double y, double z, float volume, float pitch, boolean fade) {
            for (ConfiguredSoundEvent event : this.wrappedEvents) {
                world.method_8486(x, y, z, event.event().get(), this.category, event.volume() * volume, event.pitch() * pitch, fade);
            }
        }
    }

    public record ConfiguredSoundEvent(Supplier<class_3414> event, float volume, float pitch) {
    }
}

