/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox;

import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.server.ServerCommandEvent;
import org.bukkit.generator.ChunkGenerator;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitTask;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BStats;
import world.bentobox.bentobox.Settings;
import world.bentobox.bentobox.api.configuration.Config;
import world.bentobox.bentobox.api.events.BentoBoxReadyEvent;
import world.bentobox.bentobox.api.user.Notifier;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.commands.BentoBoxCommand;
import world.bentobox.bentobox.database.DatabaseSetup;
import world.bentobox.bentobox.hooks.FancyNpcsHook;
import world.bentobox.bentobox.hooks.ItemsAdderHook;
import world.bentobox.bentobox.hooks.MultipaperHook;
import world.bentobox.bentobox.hooks.MultiverseCore4Hook;
import world.bentobox.bentobox.hooks.MultiverseCore5Hook;
import world.bentobox.bentobox.hooks.MyWorldsHook;
import world.bentobox.bentobox.hooks.MythicMobsHook;
import world.bentobox.bentobox.hooks.SlimefunHook;
import world.bentobox.bentobox.hooks.VaultHook;
import world.bentobox.bentobox.hooks.ZNPCsPlusHook;
import world.bentobox.bentobox.hooks.placeholders.PlaceholderAPIHook;
import world.bentobox.bentobox.listeners.BannedCommands;
import world.bentobox.bentobox.listeners.BlockEndDragon;
import world.bentobox.bentobox.listeners.DeathListener;
import world.bentobox.bentobox.listeners.JoinLeaveListener;
import world.bentobox.bentobox.listeners.PanelListenerManager;
import world.bentobox.bentobox.listeners.PrimaryIslandListener;
import world.bentobox.bentobox.listeners.StandardSpawnProtectionListener;
import world.bentobox.bentobox.listeners.teleports.EntityTeleportListener;
import world.bentobox.bentobox.listeners.teleports.PlayerTeleportListener;
import world.bentobox.bentobox.managers.AddonsManager;
import world.bentobox.bentobox.managers.BlueprintsManager;
import world.bentobox.bentobox.managers.CommandsManager;
import world.bentobox.bentobox.managers.FlagsManager;
import world.bentobox.bentobox.managers.HooksManager;
import world.bentobox.bentobox.managers.IslandDeletionManager;
import world.bentobox.bentobox.managers.IslandWorldManager;
import world.bentobox.bentobox.managers.IslandsManager;
import world.bentobox.bentobox.managers.LocalesManager;
import world.bentobox.bentobox.managers.PlaceholdersManager;
import world.bentobox.bentobox.managers.PlayersManager;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.managers.WebManager;
import world.bentobox.bentobox.util.heads.HeadGetter;
import world.bentobox.bentobox.versions.ServerCompatibility;

public class BentoBox
extends JavaPlugin
implements Listener {
    private static BentoBox instance;
    private PlayersManager playersManager;
    private IslandsManager islandsManager;
    private CommandsManager commandsManager;
    private LocalesManager localesManager;
    private AddonsManager addonsManager;
    private FlagsManager flagsManager;
    private IslandWorldManager islandWorldManager;
    private BlueprintsManager blueprintsManager;
    private HooksManager hooksManager;
    private PlaceholdersManager placeholdersManager;
    private IslandDeletionManager islandDeletionManager;
    private WebManager webManager;
    private Settings settings;
    private Notifier notifier;
    private HeadGetter headGetter;
    private boolean isLoaded;
    private @Nullable BStats metrics;
    private Config<Settings> configObject;
    private BukkitTask blueprintLoadingTask;
    private boolean shutdown;

    public void onEnable() {
        BentoBox.setInstance(this);
        if (!ServerCompatibility.getInstance().checkCompatibility().isCanLaunch()) {
            this.logWarning("************ Disclaimer **************");
            this.logWarning("BentoBox may not be compatible with this server!");
            this.logWarning("BentoBox is tested only on the following Paper versions:");
            List<String> versions = ServerCompatibility.ServerVersion.getVersions(ServerCompatibility.Compatibility.COMPATIBLE, ServerCompatibility.Compatibility.SUPPORTED).stream().map(ServerCompatibility.ServerVersion::toString).toList();
            this.logWarning(String.join((CharSequence)", ", versions));
            this.logWarning("**************************************");
        }
        this.isLoaded = false;
        long loadStart = System.currentTimeMillis();
        this.saveDefaultConfig();
        this.flagsManager = new FlagsManager(this);
        if (!this.loadSettings()) {
            return;
        }
        this.saveConfig();
        this.playersManager = new PlayersManager(this);
        if (!this.isEnabled()) {
            return;
        }
        this.islandsManager = new IslandsManager(this);
        this.headGetter = new HeadGetter(this);
        this.notifier = new Notifier();
        this.commandsManager = new CommandsManager();
        new BentoBoxCommand();
        this.islandWorldManager = new IslandWorldManager(this);
        this.blueprintsManager = new BlueprintsManager(this);
        this.localesManager = new LocalesManager(this);
        this.hooksManager = new HooksManager(this);
        this.addonsManager = new AddonsManager(this);
        this.addonsManager.loadAddons();
        long loadTime = System.currentTimeMillis() - loadStart;
        Bukkit.getScheduler().runTask((Plugin)instance, () -> {
            try {
                this.completeSetup(loadTime);
            }
            catch (Exception e) {
                this.fireCriticalError(e.getMessage(), "");
                e.printStackTrace();
            }
        });
    }

    private void completeSetup(long loadTime) {
        long enableStart = System.currentTimeMillis();
        this.hooksManager.registerHook(new MultipaperHook());
        this.hooksManager.registerHook(new VaultHook());
        this.hooksManager.registerHook(new FancyNpcsHook());
        this.hooksManager.registerHook(new ZNPCsPlusHook());
        this.hooksManager.registerHook(new MythicMobsHook());
        this.hooksManager.registerHook(new PlaceholderAPIHook());
        this.placeholdersManager = new PlaceholdersManager(this);
        this.addonsManager.enableAddons();
        this.addonsManager.getGameModeAddons().forEach(this.placeholdersManager::registerDefaultPlaceholders);
        this.registerListeners();
        this.log("Loading islands from database...");
        try {
            this.islandsManager.load();
        }
        catch (Exception e) {
            this.fireCriticalError(e.getMessage(), "Could not load islands!");
            return;
        }
        this.flagsManager.registerListeners();
        this.metrics = new BStats(this);
        this.metrics.registerMetrics();
        if (this.hasClass("org.mvplugins.multiverse.core.MultiverseCore")) {
            this.hooksManager.registerHook(new MultiverseCore5Hook());
        } else if (this.hasClass("com.onarandombox.MultiverseCore.MultiverseCore")) {
            this.hooksManager.registerHook(new MultiverseCore4Hook());
        }
        this.hooksManager.registerHook(new MyWorldsHook());
        this.islandWorldManager.registerWorldsToMultiverse(true);
        this.hooksManager.registerHook(new SlimefunHook());
        this.hooksManager.registerHook(new ItemsAdderHook(this));
        this.webManager = new WebManager(this);
        long enableTime = System.currentTimeMillis() - enableStart;
        User.getInstance((CommandSender)Bukkit.getConsoleSender()).sendMessage("successfully-loaded", "[version]", instance.getDescription().getVersion(), "[time]", String.valueOf(loadTime + enableTime));
        this.blueprintLoadingTask = Bukkit.getScheduler().runTaskTimer((Plugin)instance, () -> {
            if (this.getBlueprintsManager().isBlueprintsLoaded()) {
                this.blueprintLoadingTask.cancel();
                this.isLoaded = true;
                this.addonsManager.allLoaded();
                this.settings.getReadyCommands().forEach(cmd -> Bukkit.getServer().dispatchCommand((CommandSender)this.getServer().getConsoleSender(), cmd));
                Bukkit.getPluginManager().callEvent((Event)new BentoBoxReadyEvent());
                instance.log("All blueprints loaded.");
            }
        }, 0L, 1L);
        if (this.getSettings().getDatabaseType().equals((Object)DatabaseSetup.DatabaseType.YAML)) {
            this.logWarning("*** You're still using YAML database ! ***");
            this.logWarning("This database type is being deprecated from BentoBox as some official addons encountered difficulties supporting it correctly.");
            this.logWarning("You should switch ASAP to an alternative database type. Please refer to the comments in BentoBox's config.yml.");
            this.logWarning("There is NO guarantee YAML database will remain properly supported in the following updates, and its usage should as such be considered a non-viable situation.");
            this.logWarning("*** *** *** *** *** *** *** *** *** *** ***");
        }
    }

    private boolean hasClass(String className) {
        try {
            Class.forName(className);
            return true;
        }
        catch (ClassNotFoundException e) {
            return false;
        }
    }

    private void fireCriticalError(String message, String error) {
        this.logError("*****************CRITICAL ERROR!******************");
        this.logError(message);
        this.logError(error + " Disabling BentoBox...");
        this.logError("*************************************************");
        if (this.addonsManager != null) {
            this.addonsManager.disableAddons();
        }
        this.shutdown = true;
        instance.setEnabled(false);
    }

    private void registerListeners() {
        PluginManager manager = this.getServer().getPluginManager();
        manager.registerEvents((Listener)new JoinLeaveListener(this), (Plugin)this);
        manager.registerEvents((Listener)new PanelListenerManager(), (Plugin)this);
        manager.registerEvents((Listener)new StandardSpawnProtectionListener(this), (Plugin)this);
        manager.registerEvents((Listener)new PlayerTeleportListener(this), (Plugin)this);
        manager.registerEvents((Listener)new EntityTeleportListener(this), (Plugin)this);
        manager.registerEvents((Listener)new BlockEndDragon(this), (Plugin)this);
        manager.registerEvents((Listener)new BannedCommands(this), (Plugin)this);
        manager.registerEvents((Listener)new DeathListener(this), (Plugin)this);
        manager.registerEvents((Listener)this, (Plugin)this);
        this.islandDeletionManager = new IslandDeletionManager(this);
        manager.registerEvents((Listener)this.islandDeletionManager, (Plugin)this);
        manager.registerEvents((Listener)new PrimaryIslandListener(this), (Plugin)this);
    }

    public void onDisable() {
        this.shutdown = true;
        HeadGetter.shutdown();
        if (this.addonsManager != null) {
            this.addonsManager.disableAddons();
        }
        if (this.playersManager != null) {
            this.playersManager.shutdown();
        }
        if (this.islandsManager != null) {
            this.islandsManager.shutdown();
        }
    }

    @EventHandler
    public void onServerStop(ServerCommandEvent e) {
    }

    public PlayersManager getPlayers() {
        return this.playersManager;
    }

    public PlayersManager getPlayersManager() {
        return this.getPlayers();
    }

    public IslandsManager getIslands() {
        return this.islandsManager;
    }

    public IslandsManager getIslandsManager() {
        return this.getIslands();
    }

    private static void setInstance(BentoBox plugin) {
        instance = plugin;
    }

    public static BentoBox getInstance() {
        return instance;
    }

    public CommandsManager getCommandsManager() {
        return this.commandsManager;
    }

    public LocalesManager getLocalesManager() {
        return this.localesManager;
    }

    public AddonsManager getAddonsManager() {
        return this.addonsManager;
    }

    public FlagsManager getFlagsManager() {
        return this.flagsManager;
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public RanksManager getRanksManager() {
        return RanksManager.getInstance();
    }

    public IslandWorldManager getIWM() {
        return this.islandWorldManager;
    }

    public Settings getSettings() {
        return this.settings;
    }

    public boolean loadSettings() {
        this.log("Loading Settings from config.yml...");
        if (this.configObject == null) {
            this.configObject = new Config<Settings>(this, Settings.class);
        }
        this.settings = this.configObject.loadConfigObject();
        if (this.settings == null) {
            this.logError("Settings did not load correctly - disabling plugin - please check config.yml");
            this.getPluginLoader().disablePlugin((Plugin)this);
            return false;
        }
        this.log("Saving default panels...");
        if (!Files.exists(Path.of(this.getDataFolder().getPath(), "panels", "island_creation_panel.yml"), new LinkOption[0])) {
            this.log("Saving default island_creation_panel...");
            this.saveResource("panels/island_creation_panel.yml", false);
        }
        if (!Files.exists(Path.of(this.getDataFolder().getPath(), "panels", "language_panel.yml"), new LinkOption[0])) {
            this.log("Saving default language_panel...");
            this.saveResource("panels/language_panel.yml", false);
        }
        if (!Files.exists(Path.of(this.getDataFolder().getPath(), "panels", "island_homes_panel.yml"), new LinkOption[0])) {
            this.log("Saving default island_homes_panel...");
            this.saveResource("panels/island_homes_panel.yml", false);
        }
        if (!Files.exists(Path.of(this.getDataFolder().getPath(), "panels", "team_invite_panel.yml"), new LinkOption[0])) {
            this.log("Saving default team_invite_panel...");
            this.saveResource("panels/team_invite_panel.yml", false);
        }
        if (!Files.exists(Path.of(this.getDataFolder().getPath(), "panels", "team_panel.yml"), new LinkOption[0])) {
            this.log("Saving default team_panel...");
            this.saveResource("panels/team_panel.yml", false);
        }
        return true;
    }

    public void saveConfig() {
        if (this.settings != null) {
            this.configObject.saveConfigObject(this.settings);
        }
    }

    public Notifier getNotifier() {
        return this.notifier;
    }

    public HeadGetter getHeadGetter() {
        return this.headGetter;
    }

    public void log(String string) {
        this.getLogger().info(() -> string);
    }

    public void logDebug(Object object) {
        this.getLogger().info(() -> "DEBUG: " + String.valueOf(object));
    }

    public void logError(String error) {
        this.getLogger().severe(() -> error);
    }

    public void logStacktrace(@NonNull Throwable throwable) {
        this.logError(ExceptionUtils.getStackTrace((Throwable)throwable));
    }

    public void logWarning(String warning) {
        this.getLogger().warning(() -> warning);
    }

    public BlueprintsManager getBlueprintsManager() {
        return this.blueprintsManager;
    }

    public boolean isLoaded() {
        return this.isLoaded;
    }

    public HooksManager getHooks() {
        return this.hooksManager;
    }

    public Optional<VaultHook> getVault() {
        return Optional.ofNullable(this.hooksManager.getHook("Vault").orElse(null));
    }

    public PlaceholdersManager getPlaceholdersManager() {
        return this.placeholdersManager;
    }

    public IslandDeletionManager getIslandDeletionManager() {
        return this.islandDeletionManager;
    }

    public @NonNull Optional<BStats> getMetrics() {
        return Optional.ofNullable(this.metrics);
    }

    public WebManager getWebManager() {
        return this.webManager;
    }

    public ChunkGenerator getDefaultWorldGenerator(@NonNull String worldName, String id) {
        return this.addonsManager.getDefaultWorldGenerator(worldName, id);
    }

    public void reloadConfig() {
        this.loadSettings();
    }

    public boolean isShutdown() {
        return this.shutdown;
    }
}

