/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox;

import com.google.common.collect.ImmutableList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;
import world.bentobox.bentobox.api.configuration.ConfigComment;
import world.bentobox.bentobox.api.configuration.ConfigEntry;
import world.bentobox.bentobox.api.configuration.ConfigObject;
import world.bentobox.bentobox.api.configuration.StoreAt;
import world.bentobox.bentobox.database.DatabaseSetup;

@StoreAt(filename="config.yml")
@ConfigComment.Line(value={@ConfigComment(value="BentoBox v[version] configuration file."), @ConfigComment(value="")})
public class Settings
implements ConfigObject {
    @ConfigComment.Line(value={@ConfigComment(value="Default language for new players."), @ConfigComment(value="This is the filename in the locale folder without .yml."), @ConfigComment(value="If this does not exist, the default en-US will be used.")})
    @ConfigEntry(path="general.default-language")
    private String defaultLanguage = "en-US";
    @ConfigComment.Line(value={@ConfigComment(value="Use economy or not. If true, an economy plugin is required. If false, no money is used or given."), @ConfigComment(value="If there is no economy plugin present anyway, money will be automatically disabled.")})
    @ConfigEntry(path="general.use-economy")
    private boolean useEconomy = true;
    @ConfigComment.Line(value={@ConfigComment(value="Console commands to run when BentoBox has loaded all worlds and addons."), @ConfigComment(value="Commands are run as the console."), @ConfigComment(value="e.g. set aliases for worlds in Multiverse here, or anything you need to"), @ConfigComment(value="run after the plugin is fully loaded.")})
    @ConfigEntry(path="general.ready-commands", since="1.24.2")
    private List<String> readyCommands = new ArrayList<String>();
    @ConfigComment.Line(value={@ConfigComment(value="JSON, MYSQL, MARIADB, MONGODB, SQLITE, and POSTGRESQL."), @ConfigComment(value="Transition database options are:"), @ConfigComment(value="  JSON2MARIADB, JSON2MYSQL, JSON2MONGODB, JSON2SQLITE, JSON2POSTGRESQL"), @ConfigComment(value="  MYSQL2JSON, MARIADB2JSON, MONGODB2JSON, SQLITE2JSON, POSTGRESQL2JSON"), @ConfigComment(value="If you need others, please make a feature request."), @ConfigComment(value="Minimum required versions:"), @ConfigComment(value="   MySQL versions 5.7 or later"), @ConfigComment(value="   MariaDB versions 10.2.3 or later"), @ConfigComment(value="   MongoDB versions 3.6 or later"), @ConfigComment(value="   SQLite versions 3.28 or later"), @ConfigComment(value="   PostgreSQL versions 9.4 or later"), @ConfigComment(value="Transition options enable migration from one database type to another. Use /bbox migrate."), @ConfigComment(value="JSON is a file-based database."), @ConfigComment(value="MYSQL might not work with all implementations: if available, use a dedicated database type (e.g. MARIADB)."), @ConfigComment(value="BentoBox uses HikariCP for connecting with SQL databases."), @ConfigComment(value="If you use MONGODB, you must also run the BSBMongo plugin (not addon)."), @ConfigComment(value="See https://github.com/tastybento/bsbMongo/releases/.")})
    @ConfigEntry(path="general.database.type", video="https://youtu.be/FFzCk5-y7-g")
    private DatabaseSetup.DatabaseType databaseType = DatabaseSetup.DatabaseType.JSON;
    @ConfigEntry(path="general.database.host")
    private String databaseHost = "localhost";
    @ConfigComment(value="Port 3306 is MySQL's default. Port 27017 is MongoDB's default.")
    @ConfigEntry(path="general.database.port")
    private int databasePort = 3306;
    @ConfigEntry(path="general.database.name")
    private String databaseName = "bentobox";
    @ConfigEntry(path="general.database.username")
    private String databaseUsername = "username";
    @ConfigEntry(path="general.database.password")
    private String databasePassword = "password";
    @ConfigComment.Line(value={@ConfigComment(value="How often the data will be saved to file in mins. Default is 5 minutes."), @ConfigComment(value="This helps prevent issues if the server crashes."), @ConfigComment(value="Data is also saved at important points in the game.")})
    @ConfigEntry(path="general.database.backup-period")
    private int databaseBackupPeriod = 5;
    @ConfigComment.Line(value={@ConfigComment(value="How many players will be saved in one tick. Default is 200"), @ConfigComment(value="Reduce if you experience lag while saving."), @ConfigComment(value="Do not set this too low or data might get lost!")})
    @ConfigEntry(path="general.database.max-saved-players-per-tick")
    private int maxSavedPlayersPerTick = 20;
    @ConfigComment.Line(value={@ConfigComment(value="How many islands will be saved in one tick. Default is 200"), @ConfigComment(value="Reduce if you experience lag while saving."), @ConfigComment(value="Do not set this too low or data might get lost!")})
    @ConfigEntry(path="general.database.max-saved-islands-per-tick")
    private int maxSavedIslandsPerTick = 20;
    @ConfigComment.Line(value={@ConfigComment(value="Number of active connections to the SQL database at the same time."), @ConfigComment(value="Default 10.")})
    @ConfigEntry(path="general.database.max-pool-size", since="1.21.0")
    private int maximumPoolSize = 10;
    @ConfigComment(value="Enable SSL connection to MongoDB, MariaDB, MySQL and PostgreSQL databases.")
    @ConfigEntry(path="general.database.use-ssl", since="1.12.0")
    private boolean useSSL = false;
    @ConfigComment.Line(value={@ConfigComment(value="Database table prefix. Adds a prefix to the database tables. Not used by flatfile databases."), @ConfigComment(value="Only the characters A-Z, a-z, 0-9 can be used. Invalid characters will become an underscore."), @ConfigComment(value="Set this to a unique value if you are running multiple BentoBox instances that share a database."), @ConfigComment(value="Be careful about length - databases usually have a limit of 63 characters for table lengths")})
    @ConfigEntry(path="general.database.prefix-character", since="1.13.0")
    private String databasePrefix = "";
    @ConfigComment.Line(value={@ConfigComment(value="Custom connection datasource properties that will be applied to connection pool."), @ConfigComment(value="Check available values to your SQL driver implementation."), @ConfigComment(value="Example: "), @ConfigComment(value="  custom-properties: "), @ConfigComment(value="    cachePrepStmts: 'true'"), @ConfigComment(value="    prepStmtCacheSize: '250'"), @ConfigComment(value="    prepStmtCacheSqlLimit: '2048'")})
    @ConfigEntry(path="general.database.custom-properties", since="1.21.0")
    private Map<String, String> customPoolProperties = new HashMap<String, String>();
    @ConfigComment.Line(value={@ConfigComment(value="MongoDB client connection URI to override default connection options."), @ConfigComment(value="See: https://docs.mongodb.com/manual/reference/connection-string/")})
    @ConfigEntry(path="general.database.mongodb-connection-uri", since="1.14.0")
    private String mongodbConnectionUri = "";
    @ConfigComment.Line(value={@ConfigComment(value="Allow FTB Autonomous Activator to work (will allow a pseudo player [CoFH] to place and break blocks and hang items)"), @ConfigComment(value="Add other fake player names here if required")})
    @ConfigEntry(path="general.fakeplayers", experimental=true)
    private Set<String> fakePlayers = new HashSet<String>();
    @ConfigComment(value="Toggle whether panels should be closed or not when the player clicks anywhere outside of the inventory view.")
    @ConfigEntry(path="panel.close-on-click-outside")
    private boolean closePanelOnClickOutside = true;
    @ConfigComment(value="Defines the Material of the item that fills the gaps (in the header, etc.) of most panels.")
    @ConfigEntry(path="panel.filler-material", since="1.14.0")
    private Material panelFillerMaterial = Material.LIGHT_BLUE_STAINED_GLASS_PANE;
    @ConfigComment.Line(value={@ConfigComment(value="Toggle whether player head texture should be gathered from Mojang API or mc-heads.net cache server."), @ConfigComment(value="Mojang API sometime may be slow and may limit requests to the player data, so this will allow to"), @ConfigComment(value="get player heads a bit faster then Mojang API.")})
    @ConfigEntry(path="panel.use-cache-server", since="1.16.0")
    private boolean useCacheServer = false;
    @ConfigComment.Line(value={@ConfigComment(value="Defines how long player skin texture link is stored into local cache before it is requested again."), @ConfigComment(value="Defined value is in the minutes."), @ConfigComment(value="Value 0 will not clear cache until server restart.")})
    @ConfigEntry(path="panel.head-cache-time", since="1.14.1")
    private long playerHeadCacheTime = 60L;
    @ConfigComment.Line(value={@ConfigComment(value="Defines a number of player heads requested per tasks."), @ConfigComment(value="Setting it too large may lead to temporarily being blocked from head gatherer API.")})
    @ConfigEntry(path="panel.heads-per-call", since="1.16.0")
    private int headsPerCall = 9;
    @ConfigComment.Line(value={@ConfigComment(value="Defines a number of ticks between each player head request task."), @ConfigComment(value="Setting it too large may lead to temporarily being blocked from head gatherer API.")})
    @ConfigEntry(path="panel.ticks-between-calls", since="1.16.0", needsRestart=true)
    private long ticksBetweenCalls = 10L;
    @ConfigComment.Line(value={@ConfigComment(value="Toggle whether superflat chunks regeneration should be logged in the server logs or not."), @ConfigComment(value="It can be spammy if there are a lot of superflat chunks to regenerate."), @ConfigComment(value="However, as superflat chunks regeneration can be performance-intensive, it is recommended to keep"), @ConfigComment(value="this setting set to true, as it will help you know if there are regenerations taking place.")})
    @ConfigEntry(path="logs.clean-super-flat-chunks", since="1.2.0")
    private boolean logCleanSuperFlatChunks = true;
    @ConfigComment(value="Toggle whether downloading data from GitHub should be logged in the server logs or not.")
    @ConfigEntry(path="logs.github-download-data", since="1.5.0")
    private boolean logGithubDownloadData = true;
    @ConfigComment.Line(value={@ConfigComment(value="Override island distance mismatch checking. BentoBox normally refuses to run if"), @ConfigComment(value="the island distance in the gamemode config is different to the one stored in the database"), @ConfigComment(value="for safety. This overrides that check. You should never need this, and if you do not understand it"), @ConfigComment(value="keep it as false")})
    @ConfigEntry(path="island.override-safety-check")
    private boolean overrideSafetyCheck = false;
    @ConfigComment.Line(value={@ConfigComment(value="The default number of concurrent islands a player may have."), @ConfigComment(value="This may be overridden by individual game mode config settings.")})
    @ConfigEntry(path="island.concurrent-islands")
    private int islandNumber = 1;
    @ConfigComment.Line(value={@ConfigComment(value="Hide used blueprints."), @ConfigComment(value="Blueprints can have a maximum use when players have concurrent islands."), @ConfigComment(value="If this is true, then ones that are used up will not be shown in the island create menu.")})
    @ConfigEntry(path="island.hide-used-blueprints", since="2.3.0")
    private boolean hideUsedBlueprints = false;
    @ConfigComment.Line(value={@ConfigComment(value="How long a player must wait until they can rejoin a team island after being kicked in minutes."), @ConfigComment(value="This slows the effectiveness of players repeating challenges"), @ConfigComment(value="by repetitively being invited to a team island.")})
    @ConfigEntry(path="island.cooldown.time.invite")
    private int inviteCooldown = 60;
    @ConfigComment(value="How long a player must wait until they can coop a player in minutes.")
    @ConfigEntry(path="island.cooldown.time.coop")
    private int coopCooldown = 5;
    @ConfigComment(value="How long a player must wait until they can trust a player in minutes.")
    @ConfigEntry(path="island.cooldown.time.trust")
    private int trustCooldown = 5;
    @ConfigComment(value="How long a player must wait until they can ban a player after unbanning them. In minutes.")
    @ConfigEntry(path="island.cooldown.time.ban")
    private int banCooldown = 10;
    @ConfigComment(value="How long a player must wait before they can reset their island again in seconds.")
    @ConfigEntry(path="island.cooldown.time.reset")
    private int resetCooldown = 300;
    @ConfigComment(value="Whether the reset cooldown should be applied when the player creates an island for the first time or not.")
    @ConfigEntry(path="island.cooldown.options.set-reset-cooldown-on-create", since="1.2.0")
    private boolean resetCooldownOnCreate = true;
    @ConfigComment(value="Time in seconds that players have to confirm sensitive commands, e.g. island reset.")
    @ConfigEntry(path="island.confirmation.time")
    private int confirmationTime = 10;
    @ConfigComment(value="Time in seconds that players have to stand still before teleport commands activate, e.g. island go.")
    @ConfigEntry(path="island.delay.time")
    private int delayTime = 0;
    @ConfigComment(value="Ask the player to confirm the command he is using by typing it again.")
    @ConfigEntry(path="island.confirmation.commands.kick")
    private boolean kickConfirmation = true;
    @ConfigEntry(path="island.confirmation.commands.leave")
    private boolean leaveConfirmation = true;
    @ConfigEntry(path="island.confirmation.commands.reset")
    private boolean resetConfirmation = true;
    @ConfigComment.Line(value={@ConfigComment(value="Ask the recipient to confirm trust or coop invites."), @ConfigComment(value="Team invites will always require confirmation, for safety concerns.")})
    @ConfigEntry(path="island.confirmation.invites", since="1.8.0")
    private boolean inviteConfirmation = false;
    @ConfigComment(value="Sets the minimum length an island custom name is required to have.")
    @ConfigEntry(path="island.name.min-length")
    private int nameMinLength = 4;
    @ConfigComment(value="Sets the maximum length an island custom name cannot exceed.")
    @ConfigEntry(path="island.name.max-length")
    private int nameMaxLength = 20;
    @ConfigComment.Line(value={@ConfigComment(value="Requires island custom names to be unique in the gamemode the island is in."), @ConfigComment(value="As a result, only one island per gamemode are allowed to share the same name."), @ConfigComment(value="Note that island names are purely cosmetics and are not used as a way to programmatically identify islands.")})
    @ConfigEntry(path="island.name.uniqueness", since="1.7.0")
    private boolean nameUniqueness = false;
    @ConfigComment.Line(value={@ConfigComment(value="Remove hostile mob on teleport box radius"), @ConfigComment(value="If hostile mobs are cleared on player teleport, then this sized box will be cleared"), @ConfigComment(value="around the player. e.g. 5 means a 10 x 10 x 10 box around the player"), @ConfigComment(value="Be careful not to make this too big. Does not cover standard nether or end teleports.")})
    @ConfigEntry(path="island.clear-radius", since="1.6.0")
    private int clearRadius = 5;
    @ConfigComment.Line(value={@ConfigComment(value="Minimum nether portal search radius. If this is too low, duplicate portals may appear."), @ConfigComment(value="Vanilla default is 128.")})
    @ConfigEntry(path="island.portal-search-radius", since="1.16.2")
    private int minPortalSearchRadius = 64;
    @ConfigComment.Line(value={@ConfigComment(value="Number of blocks to paste per tick when pasting blueprints."), @ConfigComment(value="Smaller values will help reduce noticeable lag but will make pasting take slightly longer."), @ConfigComment(value="On the contrary, greater values will make pasting take less time, but this benefit is quickly severely impacted by the"), @ConfigComment(value="resulting amount of chunks that must be loaded to fulfill the process, which often causes the server to hang out.")})
    @ConfigEntry(path="island.paste-speed")
    private int pasteSpeed = 64;
    @ConfigComment.Line(value={@ConfigComment(value="Island deletion: Number of chunks per world to regenerate per second."), @ConfigComment(value="If there is a nether and end then 3x this number will be regenerated per second."), @ConfigComment(value="Smaller values will help reduce noticeable lag but will make deleting take longer."), @ConfigComment(value="A setting of 0 will leave island blocks (not recommended).")})
    @ConfigEntry(path="island.delete-speed", since="1.7.0")
    private int deleteSpeed = 1;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles whether islands, when players are resetting them, should be kept in the world or deleted."), @ConfigComment(value="* If set to 'true', whenever a player resets his island, his previous island will become unowned and won't be deleted from the world."), @ConfigComment(value="  You can, however, still delete those unowned islands through purging."), @ConfigComment(value="  On bigger servers, this can lead to an increasing world size."), @ConfigComment(value="  Yet, this allows admins to retrieve a player's old island in case of an improper use of the reset command."), @ConfigComment(value="  Admins can indeed re-add the player to his old island by registering him to it."), @ConfigComment(value="* If set to 'false', whenever a player resets his island, his previous island will be deleted from the world."), @ConfigComment(value="  This is the default behaviour.")})
    @ConfigEntry(path="island.deletion.keep-previous-island-on-reset", since="1.13.0")
    private boolean keepPreviousIslandOnReset = false;
    @ConfigComment.Line(value={@ConfigComment(value="Toggles how the islands are deleted."), @ConfigComment(value="* If set to 'false', all islands will be deleted at once."), @ConfigComment(value="  This is fast but may cause an impact on the performance"), @ConfigComment(value="  as it'll load all the chunks of the in-deletion islands."), @ConfigComment(value="* If set to 'true', the islands will be deleted one by one."), @ConfigComment(value="  This is slower but will not cause any impact on the performance.")})
    @ConfigEntry(path="island.deletion.slow-deletion", since="1.19.1")
    private boolean slowDeletion = false;
    @ConfigComment.Line(value={@ConfigComment(value="By default, If the destination is not safe, the plugin will try to search for a safe spot around the destination,"), @ConfigComment(value="then it will try to expand the y-coordinate up and down from the destination."), @ConfigComment(value="This setting limits how far the y-coordinate will be expanded."), @ConfigComment(value="If set to 0 or lower, the plugin will not expand the y-coordinate.")})
    @ConfigEntry(path="island.safe-spot-search-vertical-range", since="1.19.1")
    private int safeSpotSearchVerticalRange = 400;
    @ConfigComment.Line(value={@ConfigComment(value="By default, if the destination is not safe, the plugin will try to search for a safe spot around the destination."), @ConfigComment(value="This allows to change the distance for searching this spot. Larger value will mean longer position search."), @ConfigComment(value="This value is also used for valid nether portal linking between dimension.")})
    @ConfigEntry(path="island.safe-spot-search-range", since="1.21.0")
    private int safeSpotSearchRange = 16;
    @ConfigComment.Line(value={@ConfigComment(value="Toggle whether BentoBox can connect to GitHub to get data about updates and addons."), @ConfigComment(value="Disabling this will result in the deactivation of the update checker and of some other"), @ConfigComment(value="features that rely on the data downloaded from the GitHub API."), @ConfigComment(value="It does not send any data.")})
    @ConfigEntry(path="web.github.download-data", since="1.5.0")
    private boolean githubDownloadData = true;
    @ConfigComment.Line(value={@ConfigComment(value="Time in minutes between each connection to the GitHub API."), @ConfigComment(value="This allows for up-to-the-minute information gathering."), @ConfigComment(value="However, as the GitHub API data does not get updated instantly, this value cannot be set to less than 60 minutes."), @ConfigComment(value="Setting this to 0 will make BentoBox download data only at startup.")})
    @ConfigEntry(path="web.github.connection-interval", since="1.5.0")
    private int githubConnectionInterval = 120;
    @ConfigEntry(path="web.updater.check-updates.bentobox", since="1.3.0", hidden=true)
    private boolean checkBentoBoxUpdates = true;
    @ConfigEntry(path="web.updater.check-updates.addons", since="1.3.0", hidden=true)
    private boolean checkAddonsUpdates = true;

    public String getDefaultLanguage() {
        return this.defaultLanguage;
    }

    public void setDefaultLanguage(String defaultLanguage) {
        this.defaultLanguage = defaultLanguage;
    }

    public boolean isUseEconomy() {
        return this.useEconomy;
    }

    public void setUseEconomy(boolean useEconomy) {
        this.useEconomy = useEconomy;
    }

    public DatabaseSetup.DatabaseType getDatabaseType() {
        return this.databaseType;
    }

    public void setDatabaseType(DatabaseSetup.DatabaseType databaseType) {
        this.databaseType = databaseType;
    }

    public String getDatabaseHost() {
        return this.databaseHost;
    }

    public void setDatabaseHost(String databaseHost) {
        this.databaseHost = databaseHost;
    }

    public int getDatabasePort() {
        return this.databasePort;
    }

    public boolean isUseSSL() {
        return this.useSSL;
    }

    public void setUseSSL(boolean useSSL) {
        this.useSSL = useSSL;
    }

    public void setDatabasePort(int databasePort) {
        this.databasePort = databasePort;
    }

    public String getDatabaseName() {
        return this.databaseName;
    }

    public void setDatabaseName(String databaseName) {
        this.databaseName = databaseName;
    }

    public String getDatabaseUsername() {
        return this.databaseUsername;
    }

    public void setDatabaseUsername(String databaseUsername) {
        this.databaseUsername = databaseUsername;
    }

    public String getDatabasePassword() {
        return this.databasePassword;
    }

    public void setDatabasePassword(String databasePassword) {
        this.databasePassword = databasePassword;
    }

    public int getDatabaseBackupPeriod() {
        return this.databaseBackupPeriod;
    }

    public void setDatabaseBackupPeriod(int databaseBackupPeriod) {
        this.databaseBackupPeriod = databaseBackupPeriod;
    }

    public int getMaxSavedPlayersPerTick() {
        return this.maxSavedPlayersPerTick;
    }

    public void setMaxSavedPlayersPerTick(int maxSavedPlayersPerTick) {
        this.maxSavedPlayersPerTick = maxSavedPlayersPerTick;
    }

    public int getMaxSavedIslandsPerTick() {
        return this.maxSavedIslandsPerTick;
    }

    public void setMaxSavedIslandsPerTick(int maxSavedIslandsPerTick) {
        this.maxSavedIslandsPerTick = maxSavedIslandsPerTick;
    }

    public Set<String> getFakePlayers() {
        return this.fakePlayers;
    }

    public void setFakePlayers(Set<String> fakePlayers) {
        this.fakePlayers = fakePlayers;
    }

    public boolean isClosePanelOnClickOutside() {
        return this.closePanelOnClickOutside;
    }

    public void setClosePanelOnClickOutside(boolean closePanelOnClickOutside) {
        this.closePanelOnClickOutside = closePanelOnClickOutside;
    }

    public int getInviteCooldown() {
        return this.inviteCooldown;
    }

    public void setInviteCooldown(int inviteCooldown) {
        this.inviteCooldown = inviteCooldown;
    }

    public int getCoopCooldown() {
        return this.coopCooldown;
    }

    public void setCoopCooldown(int coopCooldown) {
        this.coopCooldown = coopCooldown;
    }

    public int getTrustCooldown() {
        return this.trustCooldown;
    }

    public void setTrustCooldown(int trustCooldown) {
        this.trustCooldown = trustCooldown;
    }

    public int getBanCooldown() {
        return this.banCooldown;
    }

    public void setBanCooldown(int banCooldown) {
        this.banCooldown = banCooldown;
    }

    public int getResetCooldown() {
        return this.resetCooldown;
    }

    public void setResetCooldown(int resetCooldown) {
        this.resetCooldown = resetCooldown;
    }

    public int getConfirmationTime() {
        return this.confirmationTime;
    }

    public void setConfirmationTime(int confirmationTime) {
        this.confirmationTime = confirmationTime;
    }

    public boolean isKickConfirmation() {
        return this.kickConfirmation;
    }

    public void setKickConfirmation(boolean kickConfirmation) {
        this.kickConfirmation = kickConfirmation;
    }

    public boolean isLeaveConfirmation() {
        return this.leaveConfirmation;
    }

    public void setLeaveConfirmation(boolean leaveConfirmation) {
        this.leaveConfirmation = leaveConfirmation;
    }

    public boolean isResetConfirmation() {
        return this.resetConfirmation;
    }

    public void setResetConfirmation(boolean resetConfirmation) {
        this.resetConfirmation = resetConfirmation;
    }

    public int getNameMinLength() {
        return this.nameMinLength;
    }

    public void setNameMinLength(int nameMinLength) {
        this.nameMinLength = nameMinLength;
    }

    public int getNameMaxLength() {
        return this.nameMaxLength;
    }

    public void setNameMaxLength(int nameMaxLength) {
        this.nameMaxLength = nameMaxLength;
    }

    public boolean isNameUniqueness() {
        return this.nameUniqueness;
    }

    public void setNameUniqueness(boolean nameUniqueness) {
        this.nameUniqueness = nameUniqueness;
    }

    public void setPasteSpeed(int pasteSpeed) {
        this.pasteSpeed = pasteSpeed;
    }

    public int getPasteSpeed() {
        return this.pasteSpeed;
    }

    public int getDeleteSpeed() {
        return this.deleteSpeed;
    }

    public void setDeleteSpeed(int deleteSpeed) {
        this.deleteSpeed = deleteSpeed;
    }

    public boolean isLogCleanSuperFlatChunks() {
        return this.logCleanSuperFlatChunks;
    }

    public void setLogCleanSuperFlatChunks(boolean logCleanSuperFlatChunks) {
        this.logCleanSuperFlatChunks = logCleanSuperFlatChunks;
    }

    public boolean isResetCooldownOnCreate() {
        return this.resetCooldownOnCreate;
    }

    public void setResetCooldownOnCreate(boolean resetCooldownOnCreate) {
        this.resetCooldownOnCreate = resetCooldownOnCreate;
    }

    public boolean isGithubDownloadData() {
        return this.githubDownloadData;
    }

    public void setGithubDownloadData(boolean githubDownloadData) {
        this.githubDownloadData = githubDownloadData;
    }

    public int getGithubConnectionInterval() {
        return this.githubConnectionInterval;
    }

    public void setGithubConnectionInterval(int githubConnectionInterval) {
        this.githubConnectionInterval = githubConnectionInterval;
    }

    public boolean isCheckBentoBoxUpdates() {
        return this.checkBentoBoxUpdates;
    }

    public void setCheckBentoBoxUpdates(boolean checkBentoBoxUpdates) {
        this.checkBentoBoxUpdates = checkBentoBoxUpdates;
    }

    public boolean isCheckAddonsUpdates() {
        return this.checkAddonsUpdates;
    }

    public void setCheckAddonsUpdates(boolean checkAddonsUpdates) {
        this.checkAddonsUpdates = checkAddonsUpdates;
    }

    public boolean isLogGithubDownloadData() {
        return this.logGithubDownloadData;
    }

    public void setLogGithubDownloadData(boolean logGithubDownloadData) {
        this.logGithubDownloadData = logGithubDownloadData;
    }

    public int getDelayTime() {
        return this.delayTime;
    }

    public void setDelayTime(int delayTime) {
        this.delayTime = delayTime;
    }

    public int getClearRadius() {
        if (this.clearRadius < 0) {
            this.clearRadius = 0;
        }
        return this.clearRadius;
    }

    public void setClearRadius(int clearRadius) {
        if (clearRadius < 0) {
            clearRadius = 0;
        }
        this.clearRadius = clearRadius;
    }

    public boolean isInviteConfirmation() {
        return this.inviteConfirmation;
    }

    public void setInviteConfirmation(boolean inviteConfirmation) {
        this.inviteConfirmation = inviteConfirmation;
    }

    public String getDatabasePrefix() {
        if (this.databasePrefix == null) {
            this.databasePrefix = "";
        }
        return this.databasePrefix.isEmpty() ? "" : this.databasePrefix.replaceAll("[^a-zA-Z0-9]", "_");
    }

    public void setDatabasePrefix(String databasePrefix) {
        this.databasePrefix = databasePrefix;
    }

    public boolean isKeepPreviousIslandOnReset() {
        return this.keepPreviousIslandOnReset;
    }

    public void setKeepPreviousIslandOnReset(boolean keepPreviousIslandOnReset) {
        this.keepPreviousIslandOnReset = keepPreviousIslandOnReset;
    }

    public String getMongodbConnectionUri() {
        return this.mongodbConnectionUri;
    }

    public void setMongodbConnectionUri(String mongodbConnectionUri) {
        this.mongodbConnectionUri = mongodbConnectionUri;
    }

    public Material getPanelFillerMaterial() {
        return this.panelFillerMaterial;
    }

    public void setPanelFillerMaterial(Material panelFillerMaterial) {
        this.panelFillerMaterial = panelFillerMaterial;
    }

    public long getPlayerHeadCacheTime() {
        return this.playerHeadCacheTime;
    }

    public void setPlayerHeadCacheTime(long playerHeadCacheTime) {
        this.playerHeadCacheTime = playerHeadCacheTime;
    }

    public boolean isUseCacheServer() {
        return this.useCacheServer;
    }

    public void setUseCacheServer(boolean useCacheServer) {
        this.useCacheServer = useCacheServer;
    }

    public int getHeadsPerCall() {
        return this.headsPerCall;
    }

    public void setHeadsPerCall(int headsPerCall) {
        this.headsPerCall = headsPerCall;
    }

    public long getTicksBetweenCalls() {
        return this.ticksBetweenCalls;
    }

    public void setTicksBetweenCalls(long ticksBetweenCalls) {
        this.ticksBetweenCalls = ticksBetweenCalls;
    }

    public int getMinPortalSearchRadius() {
        return this.minPortalSearchRadius;
    }

    public void setMinPortalSearchRadius(int minPortalSearchRadius) {
        this.minPortalSearchRadius = minPortalSearchRadius;
    }

    public int getSafeSpotSearchVerticalRange() {
        return this.safeSpotSearchVerticalRange;
    }

    public void setSafeSpotSearchVerticalRange(int safeSpotSearchVerticalRange) {
        this.safeSpotSearchVerticalRange = safeSpotSearchVerticalRange;
    }

    public boolean isSlowDeletion() {
        return this.slowDeletion;
    }

    public void setSlowDeletion(boolean slowDeletion) {
        this.slowDeletion = slowDeletion;
    }

    public int getMaximumPoolSize() {
        return this.maximumPoolSize;
    }

    public int getSafeSpotSearchRange() {
        return this.safeSpotSearchRange;
    }

    public void setMaximumPoolSize(int maximumPoolSize) {
        this.maximumPoolSize = maximumPoolSize;
    }

    public Map<String, String> getCustomPoolProperties() {
        return this.customPoolProperties;
    }

    public void setCustomPoolProperties(Map<String, String> customPoolProperties) {
        this.customPoolProperties = customPoolProperties;
    }

    public void setSafeSpotSearchRange(int safeSpotSearchRange) {
        this.safeSpotSearchRange = safeSpotSearchRange;
    }

    public List<String> getReadyCommands() {
        return ImmutableList.copyOf((Collection)Objects.requireNonNullElse(this.readyCommands, Collections.emptyList()));
    }

    public void setReadyCommands(List<String> readyCommands) {
        this.readyCommands = readyCommands;
    }

    public int getIslandNumber() {
        return this.islandNumber;
    }

    public void setIslandNumber(int islandNumber) {
        this.islandNumber = islandNumber;
    }

    public boolean isHideUsedBlueprints() {
        return this.hideUsedBlueprints;
    }

    public void setHideUsedBlueprints(boolean hideUsedBlueprints) {
        this.hideUsedBlueprints = hideUsedBlueprints;
    }

    public boolean isOverrideSafetyCheck() {
        return this.overrideSafetyCheck;
    }

    public void setOverrideSafetyCheck(boolean overrideSafetyCheck) {
        this.overrideSafetyCheck = overrideSafetyCheck;
    }
}

