/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.addons;

import java.io.File;
import java.lang.reflect.InvocationTargetException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import org.bukkit.Material;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.InvalidDescriptionException;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.AddonDescription;
import world.bentobox.bentobox.api.addons.exceptions.InvalidAddonDescriptionException;
import world.bentobox.bentobox.api.addons.exceptions.InvalidAddonFormatException;
import world.bentobox.bentobox.api.addons.exceptions.InvalidAddonInheritException;
import world.bentobox.bentobox.managers.AddonsManager;

public class AddonClassLoader
extends URLClassLoader {
    private final Map<String, Class<?>> classes = new HashMap();
    private final Addon addon;
    private final AddonsManager loader;

    protected AddonClassLoader(Addon addon, AddonsManager loader, File jarFile) throws MalformedURLException {
        super(new URL[]{jarFile.toURI().toURL()});
        this.addon = addon;
        this.loader = loader;
    }

    public AddonClassLoader(AddonsManager addonsManager, YamlConfiguration data, File jarFile, ClassLoader parent) throws InvalidAddonInheritException, MalformedURLException, InvalidDescriptionException, InvalidAddonDescriptionException, InstantiationException, IllegalAccessException, InvocationTargetException, NoSuchMethodException {
        super(new URL[]{jarFile.toURI().toURL()}, parent);
        Class<Addon> addonClass;
        Class<?> javaClass;
        this.loader = addonsManager;
        try {
            String mainClass = data.getString("main");
            if (mainClass == null) {
                throw new InvalidAddonFormatException("addon.yml does not define a main class!");
            }
            javaClass = Class.forName(mainClass, true, this);
            if (mainClass.startsWith("world.bentobox.bentobox")) {
                throw new InvalidAddonFormatException("Package declaration cannot start with 'world.bentobox.bentobox'");
            }
        }
        catch (Exception e) {
            throw new InvalidDescriptionException("Could not load '" + jarFile.getName() + "' in folder '" + jarFile.getParent() + "' - " + e.getMessage());
        }
        try {
            addonClass = javaClass.asSubclass(Addon.class);
        }
        catch (ClassCastException e) {
            throw new InvalidAddonInheritException("Main class does not extend 'Addon'");
        }
        this.addon = addonClass.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        this.addon.setDescription(AddonClassLoader.asDescription(data));
    }

    public static @NonNull AddonDescription asDescription(YamlConfiguration data) throws InvalidAddonDescriptionException {
        Material icon;
        String softDepend;
        if (!data.contains("main")) {
            throw new InvalidAddonDescriptionException("Missing 'main' tag. A main class must be listed in addon.yml");
        }
        if (!data.contains("name")) {
            throw new InvalidAddonDescriptionException("Missing 'name' tag. An addon name must be listed in addon.yml");
        }
        if (!data.contains("version")) {
            throw new InvalidAddonDescriptionException("Missing 'version' tag. A version must be listed in addon.yml");
        }
        if (!data.contains("authors")) {
            throw new InvalidAddonDescriptionException("Missing 'authors' tag. At least one author must be listed in addon.yml");
        }
        AddonDescription.Builder builder = new AddonDescription.Builder(Objects.requireNonNull(data.getString("main")), Objects.requireNonNull(data.getString("name")), Objects.requireNonNull(data.getString("version"))).authors(Objects.requireNonNull(data.getString("authors"))).metrics(data.getBoolean("metrics", true)).repository(data.getString("repository", ""));
        String depend = data.getString("depend");
        if (depend != null) {
            builder.dependencies(Arrays.asList(depend.split("\\s*,\\s*")));
        }
        if ((softDepend = data.getString("softdepend")) != null) {
            builder.softDependencies(Arrays.asList(softDepend.split("\\s*,\\s*")));
        }
        if ((icon = Material.getMaterial((String)data.getString("icon", "PAPER").toUpperCase(Locale.ENGLISH))) == null) {
            throw new InvalidAddonDescriptionException("'icon' tag refers to an unknown Material: " + data.getString("icon"));
        }
        builder.icon(Objects.requireNonNull(icon));
        String apiVersion = data.getString("api-version");
        if (apiVersion != null) {
            if (!apiVersion.replace("-SNAPSHOT", "").matches("^(\\d+\\.)?(\\d+\\.)?(\\*|\\d+)$")) {
                throw new InvalidAddonDescriptionException("Provided API version '" + apiVersion + "' is not valid. It must only contain digits and dots and not end with a dot.");
            }
            if (apiVersion.contains("-SNAPSHOT")) {
                BentoBox.getInstance().logWarning(data.getString("name") + " addon depends on development version of BentoBox plugin. Some functions may be not implemented.");
            }
            builder.apiVersion(apiVersion);
        }
        if (data.isConfigurationSection("permissions")) {
            builder.permissions(Objects.requireNonNull(data.getConfigurationSection("permissions")));
        }
        return builder.build();
    }

    @Override
    protected @Nullable Class<?> findClass(String name) {
        return this.findClass(name, true);
    }

    public Class<?> findClass(String name, boolean checkGlobal) {
        if (name.startsWith("world.bentobox.bentobox")) {
            return null;
        }
        Class<?> result = this.classes.get(name);
        if (result == null) {
            if (checkGlobal) {
                result = this.loader.getClassByName(name);
            }
            if (result == null) {
                try {
                    result = super.findClass(name);
                }
                catch (ClassNotFoundException | NoClassDefFoundError throwable) {
                    // empty catch block
                }
                if (result != null) {
                    this.loader.setClass(name, result);
                }
            }
            this.classes.put(name, result);
        }
        return result;
    }

    public Addon getAddon() {
        return this.addon;
    }

    public Set<String> getClasses() {
        return this.classes.keySet();
    }
}

