/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.addons.request;

import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.lang.Validate;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.addons.Addon;

public class AddonRequestBuilder {
    private String addonName;
    private String requestLabel;
    private final Map<String, Object> metaData = new HashMap<String, Object>();

    public AddonRequestBuilder addon(String addonName) {
        this.addonName = addonName;
        return this;
    }

    public AddonRequestBuilder label(String requestLabel) {
        this.requestLabel = requestLabel;
        return this;
    }

    public AddonRequestBuilder addMetaData(String key, Object value) {
        this.metaData.put(key, value);
        return this;
    }

    public Object request() {
        Validate.notNull((Object)this.addonName);
        Validate.notNull((Object)this.requestLabel);
        Optional addonOptional = BentoBox.getInstance().getAddonsManager().getAddonByName(this.addonName);
        if (addonOptional.isPresent()) {
            Addon addon = (Addon)addonOptional.get();
            return addon.request(this.requestLabel, this.metaData);
        }
        return null;
    }
}

