/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.apache.commons.lang.math.NumberUtils;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;

public class DefaultHelpCommand
extends CompositeCommand {
    protected static final int MAX_DEPTH = 2;
    protected static final String USAGE_PLACEHOLDER = "[usage]";
    protected static final String PARAMS_PLACEHOLDER = "[parameters]";
    protected static final String DESC_PLACEHOLDER = "[description]";
    protected static final String HELP_SYNTAX_REF = "commands.help.syntax";
    protected static final String HELP_SYNTAX_NO_PARAMETERS_REF = "commands.help.syntax-no-parameters";
    protected static final String HELP = "help";

    public DefaultHelpCommand(CompositeCommand parent) {
        super(parent, HELP, new String[0]);
    }

    @Override
    public void setup() {
        this.setParametersHelp(this.parent.getParameters());
        this.setDescription(this.parent.getDescription());
        this.inheritPermission();
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (this.parent.isHidden()) {
            return true;
        }
        int depth = 0;
        if (args.size() == 1) {
            if (NumberUtils.isDigits((String)args.get(0))) {
                depth = Optional.ofNullable(args.get(0)).map(NumberUtils::toInt).orElse(-1);
            } else {
                String usage = this.parent.getUsage();
                String params = user.getTranslation("commands.help.parameters", new String[0]);
                String desc = user.getTranslation("commands.help.description", new String[0]);
                user.sendMessage(HELP_SYNTAX_REF, USAGE_PLACEHOLDER, usage, PARAMS_PLACEHOLDER, params, DESC_PLACEHOLDER, desc);
                return true;
            }
        }
        if (depth == 0) {
            String labelText = this.getWorld() != null ? this.getIWM().getFriendlyName(this.getWorld()) : user.getTranslation("commands.help.console", new String[0]);
            user.sendMessage("commands.help.header", "[label]", labelText);
        }
        if (depth < 2) {
            String desc;
            String params;
            String usage;
            if (!this.parent.getLabel().equals(HELP) && this.showPrettyHelp(user, usage = this.parent.getUsage(), params = user.getTranslationOrNothing(this.getParameters(), new String[0]), desc = user.getTranslation(this.getDescription(), new String[0]))) {
                return true;
            }
            this.runSubCommandHelp(user, depth + 1);
        }
        if (depth == 0) {
            user.sendMessage("commands.help.end", new String[0]);
        }
        return true;
    }

    protected void runSubCommandHelp(User user, int newDepth) {
        for (CompositeCommand subCommand : this.parent.getSubCommands().values()) {
            if (subCommand.getLabel().equals(HELP)) continue;
            Optional<CompositeCommand> sub = subCommand.getSubCommand(HELP);
            sub.ifPresent(compositeCommand -> compositeCommand.execute(user, HELP, Collections.singletonList(String.valueOf(newDepth))));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected boolean showPrettyHelp(User user, String usage, String params, String desc) {
        if (user.isPlayer()) {
            if (!user.hasPermission(this.parent.getPermission())) return true;
            if (params == null || params.isEmpty()) {
                user.sendMessage(HELP_SYNTAX_NO_PARAMETERS_REF, USAGE_PLACEHOLDER, usage, DESC_PLACEHOLDER, desc);
                return false;
            } else {
                user.sendMessage(HELP_SYNTAX_REF, USAGE_PLACEHOLDER, usage, PARAMS_PLACEHOLDER, params, DESC_PLACEHOLDER, desc);
            }
            return false;
        } else {
            if (this.parent.isOnlyPlayer()) return false;
            if (params == null || params.isEmpty()) {
                user.sendMessage(HELP_SYNTAX_NO_PARAMETERS_REF, USAGE_PLACEHOLDER, usage, DESC_PLACEHOLDER, desc);
                return false;
            } else {
                user.sendMessage(HELP_SYNTAX_REF, USAGE_PLACEHOLDER, usage, PARAMS_PLACEHOLDER, params, DESC_PLACEHOLDER, desc);
            }
        }
        return false;
    }
}

