/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.IslandInfo;
import world.bentobox.bentobox.util.Util;

public class AdminInfoCommand
extends CompositeCommand {
    public AdminInfoCommand(CompositeCommand parent) {
        super(parent, "info", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.info");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.info.parameters");
        this.setDescription("commands.admin.info.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() > 1 || args.isEmpty() && !user.isPlayer()) {
            this.showHelp(this, user);
            return false;
        }
        if (args.isEmpty()) {
            this.getIslands().getIslandAt(user.getLocation()).ifPresentOrElse(i -> new IslandInfo((Island)i).showAdminInfo(user, (Addon)this.getAddon()), () -> user.sendMessage("commands.admin.info.no-island", new String[0]));
            return true;
        }
        UUID targetUUID = Util.getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), targetUUID);
        if (island != null) {
            new IslandInfo(island).showAdminInfo(user, (Addon)this.getAddon());
            return true;
        }
        user.sendMessage("general.errors.player-has-no-island", new String[0]);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

