/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import com.google.common.primitives.Ints;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.island.IslandGoCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminMaxHomesCommand
extends ConfirmableCommand {
    Integer maxHomes;
    Map<String, IslandGoCommand.IslandInfo> islands = new HashMap<String, IslandGoCommand.IslandInfo>();

    public AdminMaxHomesCommand(CompositeCommand parent) {
        super(parent, "setmaxhomes", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.maxhomes");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.maxhomes.parameters");
        this.setDescription("commands.admin.maxhomes.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        this.islands.clear();
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        if (args.size() == 1) {
            if (!user.isPlayer()) {
                user.sendMessage("general.errors.use-in-game", new String[0]);
                return false;
            }
            if (user.getWorld() != this.getWorld()) {
                user.sendMessage("general.errors.wrong-world", new String[0]);
                return false;
            }
            this.maxHomes = Ints.tryParse((String)args.get(0));
            if (this.maxHomes == null || this.maxHomes < 1) {
                user.sendMessage("general.errors.must-be-positive-number", "[number]", args.get(0));
                return false;
            }
            boolean onIsland = this.getIslands().getIslandAt(user.getLocation()).map(is -> {
                this.islands.put("", new IslandGoCommand.IslandInfo((Island)is, false));
                return true;
            }).orElse(false);
            if (!onIsland) {
                user.sendMessage("general.errors.not-on-island", new String[0]);
                return false;
            }
            return true;
        }
        UUID targetUUID = this.getPlayers().getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        this.maxHomes = Ints.tryParse((String)args.get(1));
        if (this.maxHomes == null) {
            user.sendMessage("general.errors.must-be-positive-number", "[number]", args.get(1));
            return false;
        }
        this.islands = IslandGoCommand.getNameIslandMap(User.getInstance(targetUUID), this.getWorld());
        if (this.islands.isEmpty()) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        if (args.size() > 2) {
            String name = String.join((CharSequence)" ", args.subList(2, args.size()));
            this.islands.keySet().removeIf(n -> !name.equalsIgnoreCase((String)n));
            if (this.islands.isEmpty()) {
                user.sendMessage("commands.admin.maxhomes.errors.unknown-island", "[name]", name);
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (this.islands.isEmpty() || this.maxHomes < 1) {
            return false;
        }
        this.islands.forEach((name, island) -> {
            island.island().setMaxHomes(this.maxHomes);
            user.sendMessage("commands.admin.maxhomes.max-homes-set", "[name]", (String)name, "[number]", String.valueOf(this.maxHomes));
        });
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        UUID targetUUID;
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.size() == 2) {
            return Optional.of(Util.getOnlinePlayerList(user));
        }
        if (args.size() > 3 && (targetUUID = this.getPlayers().getUUID(args.get(1))) != null) {
            User target = User.getInstance(targetUUID);
            return Optional.of(Util.tabLimit(new ArrayList<String>(IslandGoCommand.getNameIslandMap(target, this.getWorld()).keySet()), lastArg));
        }
        return Optional.of(List.of("1"));
    }
}

