/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.Material;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminRegisterCommand
extends ConfirmableCommand {
    private Island island;
    private Location closestIsland;
    private @Nullable UUID targetUUID;

    public AdminRegisterCommand(CompositeCommand parent) {
        super(parent, "register", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.register");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.admin.register.parameters");
        this.setDescription("commands.admin.register.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        if (!this.getWorld().equals((Object)user.getWorld())) {
            user.sendMessage("general.errors.wrong-world", new String[0]);
            return false;
        }
        this.targetUUID = Util.getUUID(args.get(0));
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        this.closestIsland = Util.getClosestIsland(user.getLocation());
        if (this.getPlugin().getIslandDeletionManager().inDeletion(this.closestIsland)) {
            user.sendMessage("commands.admin.register.in-deletion", new String[0]);
            return false;
        }
        Optional<Island> opIsland = this.getIslands().getIslandAt(user.getLocation());
        if (opIsland.isEmpty()) {
            this.askConfirmation(user, user.getTranslation("commands.admin.register.no-island-here", new String[0]), () -> this.reserve(user, (String)args.get(0)));
            return false;
        }
        this.island = opIsland.get();
        if (this.targetUUID.equals(this.island.getOwner())) {
            user.sendMessage("commands.admin.register.already-owned", new String[0]);
            return false;
        }
        if (this.island.isSpawn()) {
            this.askConfirmation(user, user.getTranslation("commands.admin.register.island-is-spawn", new String[0]), () -> this.register(user, (String)args.get(0)));
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        this.register(user, args.get(0));
        return true;
    }

    void reserve(User user, String targetName) {
        Objects.requireNonNull(this.closestIsland);
        Objects.requireNonNull(this.targetUUID);
        Island i = this.getIslands().createIsland(this.closestIsland, this.targetUUID);
        if (i == null) {
            user.sendMessage("commands.admin.register.cannot-make-island", new String[0]);
            return;
        }
        this.getIslands().setOwner(user, this.targetUUID, i, 0);
        i.setReserved(true);
        i.getCenter().getBlock().setType(Material.BEDROCK);
        user.sendMessage("commands.admin.register.reserved-island", "[xyz]", Util.xyz(i.getCenter().toVector()), "[name]", targetName);
        IslandEvent.builder().island(i).location(i.getCenter()).reason(IslandEvent.Reason.RESERVED).involvedPlayer(this.targetUUID).admin(true).build();
    }

    void register(User user, String targetName) {
        Objects.requireNonNull(this.closestIsland);
        Objects.requireNonNull(this.targetUUID);
        Objects.requireNonNull(this.island);
        this.getIslands().setOwner(user, this.targetUUID, this.island, 0);
        if (this.island.isSpawn()) {
            this.getIslands().clearSpawn(this.island.getWorld());
        }
        user.sendMessage("commands.admin.register.registered-island", "[xyz]", Util.xyz(this.island.getCenter().toVector()), "[name]", targetName);
        user.sendMessage("general.success", new String[0]);
        IslandEvent.builder().island(this.island).location(this.island.getCenter()).reason(IslandEvent.Reason.REGISTERED).involvedPlayer(this.targetUUID).admin(true).build();
        IslandEvent.builder().island(this.island).involvedPlayer(this.targetUUID).admin(true).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(0, 1000).build();
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

