/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.List;
import java.util.Locale;
import java.util.Optional;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminResetFlagsCommand
extends ConfirmableCommand {
    private final List<String> options = this.getPlugin().getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)Flag.Type.PROTECTION) || f.getType().equals((Object)Flag.Type.SETTING)).map(Flag::getID).toList();

    public AdminResetFlagsCommand(CompositeCommand parent) {
        super(parent, "resetflags", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.resetflags");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.resetflags.parameters");
        this.setDescription("commands.admin.resetflags.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            this.askConfirmation(user, user.getTranslation("commands.admin.resetflags.confirm", new String[0]), () -> {
                this.getIslands().resetAllFlags(this.getWorld());
                user.sendMessage("commands.admin.resetflags.success", new String[0]);
            });
            return true;
        }
        if (args.size() == 1 && this.options.contains(args.get(0).toUpperCase(Locale.ENGLISH))) {
            this.getPlugin().getFlagsManager().getFlag(args.get(0).toUpperCase(Locale.ENGLISH)).ifPresent(flag -> this.askConfirmation(user, user.getTranslation("commands.admin.resetflags.confirm", new String[0]), () -> {
                this.getIslands().resetFlag(this.getWorld(), (Flag)flag);
                user.sendMessage("commands.admin.resetflags.success-one", "[name]", flag.getID());
            }));
            return true;
        }
        this.showHelp(this, user);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        return Optional.of(Util.tabLimit(this.options, lastArg));
    }
}

