/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.island.IslandGoCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminResetHomeCommand
extends CompositeCommand {
    Map<String, IslandGoCommand.IslandInfo> islands = new HashMap<String, IslandGoCommand.IslandInfo>();

    public AdminResetHomeCommand(CompositeCommand command) {
        super(command, "resethome", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("mod.resethome");
        this.setDescription("commands.admin.resethome.description");
        this.setParametersHelp("commands.admin.resethome.parameters");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        this.islands.clear();
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        UUID targetUUID = this.getPlayers().getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        this.islands = IslandGoCommand.getNameIslandMap(User.getInstance(targetUUID), this.getWorld());
        if (this.islands.isEmpty()) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        if (args.size() == 1) {
            return true;
        }
        String name = String.join((CharSequence)" ", args.subList(1, args.size()));
        this.islands.keySet().removeIf(n -> !name.equalsIgnoreCase((String)n));
        if (this.islands.isEmpty()) {
            user.sendMessage("commands.admin.maxhomes.errors.unknown-island", "[name]", name);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (this.islands.isEmpty()) {
            return false;
        }
        this.islands.forEach((name, island) -> {
            island.island().getHomes().keySet().removeIf(String::isEmpty);
            user.sendMessage("commands.admin.resethome.cleared", "[name]", (String)name);
        });
        user.sendMessage("general.success", new String[0]);
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        UUID targetUUID;
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.size() == 2) {
            return Optional.of(Util.getOnlinePlayerList(user));
        }
        if (args.size() > 2 && (targetUUID = this.getPlayers().getUUID(args.get(0))) != null) {
            User target = User.getInstance(targetUUID);
            return Optional.of(Util.tabLimit(new ArrayList<String>(IslandGoCommand.getNameIslandMap(target, this.getWorld()).keySet()), lastArg));
        }
        return Optional.empty();
    }
}

