/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.List;
import java.util.Optional;
import org.bukkit.Location;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminSetProtectionCenterCommand
extends ConfirmableCommand {
    private Location targetLoc;
    private Island island;

    public AdminSetProtectionCenterCommand(CompositeCommand parent) {
        super(parent, "setprotectionlocation", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.setprotectionlocation");
        this.setParametersHelp("commands.admin.setprotectionlocation.parameters");
        this.setDescription("commands.admin.setprotectionlocation.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        this.targetLoc = args.size() == 3 ? this.getLocation(args) : new Location(this.getWorld(), (double)user.getLocation().getBlockX(), (double)user.getLocation().getBlockY(), (double)user.getLocation().getBlockZ());
        if (this.targetLoc == null) {
            user.sendMessage("commands.admin.setprotectionlocation.xyz-error", new String[0]);
            return false;
        }
        Optional<Island> optionalIsland = this.getIslands().getIslandAt(this.targetLoc);
        if (optionalIsland.isEmpty()) {
            user.sendMessage("commands.admin.setspawnpoint.no-island-here", new String[0]);
            return false;
        }
        this.island = optionalIsland.get();
        return true;
    }

    private Location getLocation(List<String> args) {
        try {
            int x = Integer.parseInt(args.get(0));
            int y = Integer.parseInt(args.get(1));
            int z = Integer.parseInt(args.get(2));
            return new Location(this.getWorld(), (double)x, (double)y, (double)z);
        }
        catch (Exception e) {
            return null;
        }
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        String name = this.getPlayers().getName(this.island.getOwner());
        user.sendMessage("commands.admin.setprotectionlocation.island", "[xyz]", Util.xyz(this.island.getCenter().toVector()), "[name]", name);
        this.askConfirmation(user, user.getTranslation("commands.admin.setprotectionlocation.confirmation", "[xyz]", Util.xyz(this.targetLoc.toVector())), () -> this.setLocation(user));
        return true;
    }

    private void setLocation(User user) {
        try {
            this.island.setProtectionCenter(this.targetLoc);
            user.sendMessage("commands.admin.setprotectionlocation.success", "[xyz]", Util.xyz(this.targetLoc.toVector()));
        }
        catch (Exception e) {
            user.sendMessage("commands.admin.setprotectionlocation.failure", "[xyz]", Util.xyz(this.targetLoc.toVector()));
            ((Addon)this.getAddon()).logError("Protection location could not be changed because the island does not exist");
        }
    }
}

