/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class AdminSetrankCommand
extends CompositeCommand {
    private int rankValue;
    private @Nullable UUID targetUUID;
    private @Nullable UUID ownerUUID;

    public AdminSetrankCommand(CompositeCommand adminCommand) {
        super(adminCommand, "setrank", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.setrank");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.setrank.parameters");
        this.setDescription("commands.admin.setrank.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 2 && args.size() != 3) {
            this.showHelp(this, user);
            return false;
        }
        this.targetUUID = Util.getUUID(args.get(0));
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        this.rankValue = RanksManager.getInstance().getRanks().entrySet().stream().filter(r -> user.getTranslation((String)r.getKey(), new String[0]).equalsIgnoreCase((String)args.get(1))).findFirst().map(Map.Entry::getValue).orElse(-999);
        if (this.rankValue < -1) {
            user.sendMessage("commands.admin.setrank.unknown-rank", new String[0]);
            return false;
        }
        if (this.rankValue <= 0) {
            user.sendMessage("commands.admin.setrank.not-possible", new String[0]);
            return false;
        }
        if (args.size() == 2) {
            if (!this.getIslands().hasIsland(this.getWorld(), this.targetUUID) && !this.getPlugin().getIslands().inTeam(this.getWorld(), this.targetUUID)) {
                user.sendMessage("general.errors.player-has-no-island", new String[0]);
                return false;
            }
        } else {
            this.ownerUUID = this.getPlayers().getUUID(args.get(2));
            if (this.ownerUUID == null) {
                user.sendMessage("general.errors.unknown-player", "[name]", args.get(2));
                return false;
            }
            if (!this.getPlugin().getIslands().hasIsland(this.getWorld(), this.ownerUUID)) {
                user.sendMessage("general.errors.player-is-not-owner", "[name]", args.get(2));
                return false;
            }
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        User target = User.getInstance(this.targetUUID);
        Island island = this.ownerUUID != null ? this.getIslands().getIsland(this.getWorld(), this.ownerUUID) : this.getIslands().getIsland(this.getWorld(), this.targetUUID);
        if (island == null) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        int currentRank = island.getRank(target);
        island.setRank(target, this.rankValue);
        IslandEvent.builder().island(island).involvedPlayer(this.targetUUID).admin(true).reason(IslandEvent.Reason.RANK_CHANGE).rankChange(currentRank, this.rankValue).build();
        String ownerName = this.ownerUUID != null ? this.getPlayers().getName(this.ownerUUID) : target.getName();
        user.sendMessage("commands.admin.setrank.rank-set", "[from]", user.getTranslation(RanksManager.getInstance().getRank(currentRank), new String[0]), "[to]", user.getTranslation(RanksManager.getInstance().getRank(this.rankValue), new String[0]), "[name]", ownerName);
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        if (args.size() == 2) {
            return Optional.of(Util.getOnlinePlayerList(user));
        }
        if (args.size() == 3) {
            return Optional.of(RanksManager.getInstance().getRanks().entrySet().stream().filter(entry -> (Integer)entry.getValue() > 0).map(entry -> user.getTranslation((String)entry.getKey(), new String[0])).toList());
        }
        if (args.size() == 4) {
            return Optional.of(Util.getOnlinePlayerList(user));
        }
        return Optional.empty();
    }
}

