/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.flags.Flag;
import world.bentobox.bentobox.api.panels.builders.TabbedPanelBuilder;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.panels.settings.SettingsTab;
import world.bentobox.bentobox.panels.settings.WorldDefaultSettingsTab;
import world.bentobox.bentobox.util.Util;

public class AdminSettingsCommand
extends CompositeCommand {
    private static final String SPAWN_ISLAND = "spawn-island";
    private List<String> protectionFlagNames;
    private Island island;
    private List<String> settingFlagNames;
    private List<String> worldSettingFlagNames;
    private @NonNull Optional<Flag> flag = Optional.empty();
    private boolean activeState;
    private int rank;
    private final GameModeAddon gameMode = this.getPlugin().getIWM().getAddon(this.getWorld()).orElse(null);

    public AdminSettingsCommand(CompositeCommand islandCommand) {
        super(islandCommand, "settings", "flags", "options");
    }

    private void makeLists() {
        this.protectionFlagNames = this.getPlugin().getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)Flag.Type.PROTECTION)).filter(f -> f.getGameModes().isEmpty() || this.gameMode == null || f.getGameModes().contains(this.gameMode)).map(Flag::getID).toList();
        this.settingFlagNames = this.getPlugin().getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)Flag.Type.SETTING)).filter(f -> f.getGameModes().isEmpty() || this.gameMode == null || f.getGameModes().contains(this.gameMode)).map(Flag::getID).toList();
        this.worldSettingFlagNames = this.getPlugin().getFlagsManager().getFlags().stream().filter(f -> f.getType().equals((Object)Flag.Type.WORLD_SETTING)).filter(f -> f.getGameModes().isEmpty() || this.gameMode == null || f.getGameModes().contains(this.gameMode)).map(Flag::getID).toList();
    }

    @Override
    public void setup() {
        this.setPermission("admin.settings");
        this.setParametersHelp("commands.admin.settings.parameters");
        this.setDescription("commands.admin.settings.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.isEmpty()) {
            return true;
        }
        if (args.size() > 1) {
            return this.checkSyntax(user, args);
        }
        return this.getIsland(user, args);
    }

    private boolean getIsland(User user, List<String> args) {
        if (args.get(0).equalsIgnoreCase(SPAWN_ISLAND) && this.getIslands().getSpawn(this.getWorld()).isPresent()) {
            this.island = this.getIslands().getSpawn(this.getWorld()).get();
            return true;
        }
        @Nullable UUID targetUUID = Util.getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        this.island = this.getIslands().getIsland(this.getWorld(), targetUUID);
        if (this.island == null || !this.getPlugin().getIslands().hasIsland(this.getWorld(), targetUUID)) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        return true;
    }

    private boolean checkSyntax(User user, List<String> args) {
        this.makeLists();
        int argSize = args.size();
        if (argSize == 2) {
            return this.checkWorldSetting(user, args);
        }
        if (argSize > 2) {
            return this.checkIslandSetting(user, args);
        }
        return false;
    }

    private boolean checkWorldSetting(User user, List<String> args) {
        String arg0 = args.get(0).toUpperCase(Locale.ENGLISH);
        if (this.worldSettingFlagNames.contains(arg0)) {
            if (this.checkActiveDisabled(user, args.get(1))) {
                this.flag = this.getPlugin().getFlagsManager().getFlag(args.get(0).toUpperCase(Locale.ENGLISH));
                return true;
            }
        } else {
            this.showHelp(this, user);
            return false;
        }
        return false;
    }

    private boolean checkIslandSetting(User user, List<String> args) {
        if (!this.getIsland(user, args)) {
            return false;
        }
        String arg1 = args.get(1).toUpperCase(Locale.ENGLISH);
        if (!this.settingFlagNames.contains(arg1) && !this.protectionFlagNames.contains(arg1)) {
            user.sendMessage("commands.admin.settings.unknown-flag", "[name]", args.get(2));
            return false;
        }
        this.flag = this.getPlugin().getFlagsManager().getFlag(arg1);
        if (this.flag.isPresent()) {
            if (this.flag.get().getType().equals((Object)Flag.Type.SETTING)) {
                return this.checkActiveDisabled(user, args.get(2));
            }
            return this.checkRank(user, String.join((CharSequence)" ", args.subList(2, args.size())));
        }
        return false;
    }

    private boolean checkRank(User user, String string) {
        for (Map.Entry<String, Integer> en : RanksManager.getInstance().getRanks().entrySet()) {
            if (en.getValue() <= -1 || en.getValue() > 1000 || !string.equalsIgnoreCase(Util.stripColor(user.getTranslation(en.getKey(), new String[0])))) continue;
            this.rank = en.getValue();
            return true;
        }
        user.sendMessage("commands.admin.setrank.unknown-rank", new String[0]);
        return false;
    }

    private boolean checkActiveDisabled(User user, String string) {
        String active = Util.stripColor(user.getTranslation("protection.panel.flag-item.setting-active", new String[0]));
        String disabled = Util.stripColor(user.getTranslation("protection.panel.flag-item.setting-disabled", new String[0]));
        if (!string.equalsIgnoreCase(active) && !string.equalsIgnoreCase(disabled)) {
            user.sendMessage("commands.admin.settings.unknown-setting", "[name]", string);
            return false;
        }
        this.activeState = string.equalsIgnoreCase(active);
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() > 1) {
            this.flag.ifPresent(f -> {
                switch (f.getType()) {
                    case PROTECTION: {
                        this.island.setFlag((Flag)f, this.rank);
                        break;
                    }
                    case SETTING: {
                        this.island.setSettingsFlag((Flag)f, this.activeState);
                        break;
                    }
                    case WORLD_SETTING: {
                        f.setSetting(this.getWorld(), this.activeState);
                        break;
                    }
                }
            });
            user.sendMessage("general.success", new String[0]);
            return true;
        }
        if (!user.isPlayer()) {
            user.sendMessage("general.errors.use-in-game", new String[0]);
            return false;
        }
        if (args.isEmpty()) {
            new TabbedPanelBuilder().user(user).world(this.getWorld()).tab(1, new SettingsTab(this.getWorld(), user, Flag.Type.WORLD_SETTING, Flag.Mode.EXPERT)).tab(2, new WorldDefaultSettingsTab(this.getWorld(), user)).startingSlot(1).size(54).build().openPanel();
            return true;
        }
        new TabbedPanelBuilder().user(user).world(this.island.getWorld()).island(this.island).tab(1, new SettingsTab(this.getWorld(), user, Flag.Type.PROTECTION, Flag.Mode.EXPERT)).tab(2, new SettingsTab(this.getWorld(), user, Flag.Type.SETTING, Flag.Mode.EXPERT)).startingSlot(1).size(54).build().openPanel();
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        this.makeLists();
        String active = Util.stripColor(user.getTranslation("protection.panel.flag-item.setting-active", new String[0]));
        String disabled = Util.stripColor(user.getTranslation("protection.panel.flag-item.setting-disabled", new String[0]));
        List<Object> options = new ArrayList();
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.size() == 2) {
            options = Util.tabLimit(Util.getOnlinePlayerList(user), lastArg);
            options.addAll(this.worldSettingFlagNames);
            if (this.getIslands().getSpawn(this.getWorld()).isPresent()) {
                options.add(SPAWN_ISLAND);
            }
        } else if (args.size() == 3) {
            if (this.worldSettingFlagNames.contains(args.get(1).toUpperCase(Locale.ENGLISH))) {
                options = Arrays.asList(active, disabled);
            } else {
                options.addAll(this.protectionFlagNames);
                options.addAll(this.settingFlagNames);
            }
        } else if (args.size() == 4) {
            options = this.getPlugin().getFlagsManager().getFlag(args.get(2).toUpperCase(Locale.ENGLISH)).map(f -> switch (f.getType()) {
                case Flag.Type.PROTECTION -> RanksManager.getInstance().getRanks().entrySet().stream().filter(en -> (Integer)en.getValue() > -1 && (Integer)en.getValue() <= 1000).map(Map.Entry::getKey).map(x$0 -> user.getTranslation((String)x$0, new String[0])).toList();
                case Flag.Type.SETTING -> Arrays.asList(active, disabled);
                default -> Collections.emptyList();
            }).orElse(Collections.emptyList());
        }
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

