/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.island.IslandGoCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;
import world.bentobox.bentobox.util.teleport.SafeSpotTeleport;

public class AdminTeleportCommand
extends CompositeCommand {
    private static final String NOT_SAFE = "general.errors.no-safe-location-found";
    private @Nullable UUID targetUUID;
    private Location warpSpot;

    public AdminTeleportCommand(CompositeCommand parent, String tpCommand) {
        super(parent, tpCommand, new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.tp");
        this.setParametersHelp("commands.admin.tp.parameters");
        this.setDescription("commands.admin.tp.description");
        this.setOnlyPlayer(true);
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        String name;
        if (args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        if (!user.isPlayer()) {
            user.sendMessage("general.errors.use-in-game", new String[0]);
            return false;
        }
        this.targetUUID = Util.getUUID(args.get(0));
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        if (!this.getIslands().hasIsland(this.getWorld(), this.targetUUID) && !this.getIslands().inTeam(this.getWorld(), this.targetUUID)) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        World world = this.getWorld();
        if (this.getLabel().equals("tpnether")) {
            world = this.getPlugin().getIWM().getNetherWorld(this.getWorld());
        } else if (this.getLabel().equals("tpend")) {
            world = this.getPlugin().getIWM().getEndWorld(this.getWorld());
        }
        if (world == null) {
            user.sendMessage(NOT_SAFE, new String[0]);
            return false;
        }
        this.warpSpot = this.getSpot(world);
        if (this.warpSpot == null) {
            user.sendMessage(NOT_SAFE, new String[0]);
            return false;
        }
        if (args.size() == 1) {
            return true;
        }
        Map<String, IslandGoCommand.IslandInfo> names = IslandGoCommand.getNameIslandMap(User.getInstance(this.targetUUID), this.getWorld());
        if (!names.containsKey(name = String.join((CharSequence)" ", args.subList(1, args.size())))) {
            user.sendMessage("commands.island.go.unknown-home", new String[0]);
            user.sendMessage("commands.island.sethome.homes-are", new String[0]);
            names.keySet().forEach(n -> user.sendMessage("commands.island.sethome.home-list-syntax", "[name]", (String)n));
            return false;
        }
        if (names.size() > 1) {
            IslandGoCommand.IslandInfo info = names.get(name);
            Island island = info.island();
            this.warpSpot = island.getSpawnPoint(world.getEnvironment()) != null ? island.getSpawnPoint(world.getEnvironment()) : island.getProtectionCenter().toVector().toLocation(world);
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Player player;
        Objects.requireNonNull(this.warpSpot);
        String failureMessage = user.getTranslation("commands.admin.tp.manual", "[location]", this.warpSpot.getBlockX() + " " + this.warpSpot.getBlockY() + " " + this.warpSpot.getBlockZ());
        Player player2 = player = args.size() == 2 ? user.getPlayer() : user.getPlayer();
        if (args.size() == 2) {
            failureMessage = user.getTranslation(NOT_SAFE, new String[0]);
        }
        new SafeSpotTeleport.Builder(this.getPlugin()).entity((Entity)player).location(this.warpSpot).failureMessage(failureMessage).thenRun(() -> user.sendMessage("general.success", new String[0])).build();
        return true;
    }

    private Location getSpot(World world) {
        Island island = this.getIslands().getIsland(world, this.targetUUID);
        if (island == null) {
            return null;
        }
        return island.getSpawnPoint(world.getEnvironment()) != null ? island.getSpawnPoint(world.getEnvironment()) : island.getProtectionCenter().toVector().toLocation(world);
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        if (args.size() == 2) {
            return Optional.of(Util.tabLimit(new ArrayList<String>(Util.getOnlinePlayerList(user)), lastArg));
        }
        if (args.size() == 3) {
            UUID target = Util.getUUID(args.get(1));
            return target == null ? Optional.empty() : Optional.of(Util.tabLimit(new ArrayList<String>(IslandGoCommand.getNameIslandMap(User.getInstance(target), this.getWorld()).keySet()), lastArg));
        }
        return Optional.empty();
    }
}

