/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.metadata.FixedMetadataValue;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminWhyCommand
extends ConfirmableCommand {
    public AdminWhyCommand(CompositeCommand parent) {
        super(parent, "why", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.why");
        this.setParametersHelp("commands.admin.why.parameters");
        this.setDescription("commands.admin.why.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        boolean newValue;
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        UUID targetUUID = Util.getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        User target = User.getInstance(targetUUID);
        if (!target.isOnline()) {
            user.sendMessage("general.errors.offline-player", new String[0]);
            return false;
        }
        boolean bl = newValue = target.getPlayer().getMetadata(this.getWorld().getName() + "_why_debug").stream().filter(p -> this.getPlugin().equals(p.getOwningPlugin())).findFirst().map(MetadataValue::asBoolean).orElse(false) == false;
        if (newValue) {
            user.sendMessage("commands.admin.why.turning-on", "[name]", target.getName());
        } else {
            user.sendMessage("commands.admin.why.turning-off", "[name]", target.getName());
        }
        target.getPlayer().setMetadata(this.getWorld().getName() + "_why_debug", (MetadataValue)new FixedMetadataValue((Plugin)this.getPlugin(), (Object)newValue));
        if (user.isPlayer()) {
            target.getPlayer().setMetadata(this.getWorld().getName() + "_why_debug_issuer", (MetadataValue)new FixedMetadataValue((Plugin)this.getPlugin(), (Object)user.getUniqueId().toString()));
        }
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

