/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.blueprints;

import java.io.File;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Color;
import org.bukkit.Particle;
import org.bukkit.plugin.Plugin;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintCopyCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintDeleteCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintListCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintLoadCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintOriginCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintPasteCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintPos1Command;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintPos2Command;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintRenameCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintSaveCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintSinkCommand;
import world.bentobox.bentobox.api.commands.admin.range.AdminRangeDisplayCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.BlueprintClipboard;
import world.bentobox.bentobox.panels.BlueprintManagementPanel;

public class AdminBlueprintCommand
extends ConfirmableCommand {
    private Map<UUID, BlueprintClipboard> clipboards;
    private Map<User, Integer> displayClipboards;
    private static final Particle.DustOptions PARTICLE_DUST_OPTIONS = new Particle.DustOptions(Color.RED, 1.0f);

    public AdminBlueprintCommand(CompositeCommand parent) {
        super(parent, "blueprint", "bp", "blu");
    }

    @Override
    public void setup() {
        this.setPermission("admin.blueprint");
        this.setParametersHelp("commands.admin.blueprint.parameters");
        this.setDescription("commands.admin.blueprint.description");
        this.setOnlyPlayer(true);
        this.clipboards = new HashMap<UUID, BlueprintClipboard>();
        this.displayClipboards = new HashMap<User, Integer>();
        new AdminBlueprintLoadCommand(this);
        new AdminBlueprintPasteCommand(this);
        new AdminBlueprintOriginCommand(this);
        new AdminBlueprintCopyCommand(this);
        new AdminBlueprintSaveCommand(this);
        new AdminBlueprintRenameCommand(this);
        new AdminBlueprintDeleteCommand(this);
        new AdminBlueprintPos1Command(this);
        new AdminBlueprintPos2Command(this);
        new AdminBlueprintListCommand(this);
        new AdminBlueprintSinkCommand(this);
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        new BlueprintManagementPanel(this.getPlugin(), user, (GameModeAddon)this.getAddon()).openPanel();
        return true;
    }

    protected Map<UUID, BlueprintClipboard> getClipboards() {
        return this.clipboards;
    }

    protected void showClipboard(User user) {
        this.displayClipboards.computeIfAbsent(user, key -> Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this.getPlugin(), () -> {
            if (!key.isPlayer() || !key.getPlayer().isOnline()) {
                this.hideClipboard((User)key);
            }
            if (this.clipboards.containsKey(key.getUniqueId())) {
                BlueprintClipboard clipboard = this.clipboards.get(key.getUniqueId());
                this.paintAxis((User)key, clipboard);
            }
        }, 20L, 20L));
    }

    private void paintAxis(User user, BlueprintClipboard clipboard) {
        if (clipboard.getPos1() == null || clipboard.getPos2() == null) {
            return;
        }
        int minX = Math.min(clipboard.getPos1().getBlockX(), clipboard.getPos2().getBlockX());
        int minY = Math.min(clipboard.getPos1().getBlockY(), clipboard.getPos2().getBlockY());
        int minZ = Math.min(clipboard.getPos1().getBlockZ(), clipboard.getPos2().getBlockZ());
        int maxX = Math.max(clipboard.getPos1().getBlockX(), clipboard.getPos2().getBlockX());
        int maxY = Math.max(clipboard.getPos1().getBlockY(), clipboard.getPos2().getBlockY());
        int maxZ = Math.max(clipboard.getPos1().getBlockZ(), clipboard.getPos2().getBlockZ());
        for (int x = minX; x <= maxX; ++x) {
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)x + 0.5, (double)minY + 0.5, (double)minZ + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)x + 0.5, (double)maxY + 0.5, (double)minZ + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)x + 0.5, (double)minY + 0.5, (double)maxZ + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)x + 0.5, (double)maxY + 0.5, (double)maxZ + 0.5);
        }
        for (int y = minY; y <= maxY; ++y) {
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)minX + 0.5, (double)y + 0.5, (double)minZ + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)maxX + 0.5, (double)y + 0.5, (double)minZ + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)minX + 0.5, (double)y + 0.5, (double)maxZ + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)maxX + 0.5, (double)y + 0.5, (double)maxZ + 0.5);
        }
        for (int z = minZ; z <= maxZ; ++z) {
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)minX + 0.5, (double)minY + 0.5, (double)z + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)maxX + 0.5, (double)minY + 0.5, (double)z + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)minX + 0.5, (double)maxY + 0.5, (double)z + 0.5);
            user.spawnParticle(AdminRangeDisplayCommand.PARTICLE, PARTICLE_DUST_OPTIONS, (double)maxX + 0.5, (double)maxY + 0.5, (double)z + 0.5);
        }
    }

    protected void hideClipboard(User user) {
        if (this.displayClipboards.containsKey(user)) {
            Bukkit.getScheduler().cancelTask(this.displayClipboards.get(user).intValue());
            this.displayClipboards.remove(user);
        }
    }

    protected File getBlueprintsFolder() {
        return new File(this.getIWM().getDataFolder(this.getWorld()), "blueprints");
    }
}

