/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.blueprints;

import java.io.File;
import java.io.FilenameFilter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.managers.BlueprintClipboardManager;
import world.bentobox.bentobox.util.Util;

public class AdminBlueprintLoadCommand
extends CompositeCommand {
    private static final FilenameFilter BLUEPRINT_FILTER = (dir, name) -> name.endsWith(".blu");

    public AdminBlueprintLoadCommand(AdminBlueprintCommand parent) {
        super(parent, "load", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.blueprint.load");
        this.setParametersHelp("commands.admin.blueprint.load.parameters");
        this.setDescription("commands.admin.blueprint.load.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        AdminBlueprintCommand parent = (AdminBlueprintCommand)this.getParent();
        BlueprintClipboardManager bp = new BlueprintClipboardManager(this.getPlugin(), parent.getBlueprintsFolder());
        if (bp.load(user, Util.sanitizeInput(args.get(0)))) {
            parent.getClipboards().put(user.getUniqueId(), bp.getClipboard());
            return true;
        }
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        List<String> options = new ArrayList<String>();
        AdminBlueprintCommand parent = (AdminBlueprintCommand)this.getParent();
        File folder = parent.getBlueprintsFolder();
        if (folder.exists()) {
            options = Arrays.asList(folder.list(BLUEPRINT_FILTER)).stream().map(n -> n.substring(0, n.length() - 4)).toList();
        }
        String lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

