/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.blueprints;

import java.io.File;
import java.util.List;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.Blueprint;
import world.bentobox.bentobox.util.Util;

public class AdminBlueprintRenameCommand
extends ConfirmableCommand {
    public AdminBlueprintRenameCommand(AdminBlueprintCommand parent) {
        super(parent, "rename", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.blueprint.rename");
        this.setParametersHelp("commands.admin.blueprint.rename.parameters");
        this.setDescription("commands.admin.blueprint.rename.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        String to;
        if (args.size() != 2) {
            this.showHelp(this, user);
            return false;
        }
        String from = Util.sanitizeInput(args.get(0));
        if (from.equals(to = Util.sanitizeInput(args.get(1)))) {
            user.sendMessage("commands.admin.blueprint.rename.pick-different-name", new String[0]);
            return false;
        }
        AdminBlueprintCommand parent = (AdminBlueprintCommand)this.getParent();
        File fromFile = new File(parent.getBlueprintsFolder(), from + ".blu");
        if (!fromFile.exists()) {
            user.sendMessage("commands.admin.blueprint.no-such-file", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        AdminBlueprintCommand parent = (AdminBlueprintCommand)this.getParent();
        String from = Util.sanitizeInput(args.get(0));
        String to = Util.sanitizeInput(args.get(1));
        File toFile = new File(parent.getBlueprintsFolder(), to + ".blu");
        if (toFile.exists()) {
            this.askConfirmation(user, user.getTranslation("commands.admin.blueprint.file-exists", new String[0]), () -> this.rename(user, from, to, (String)args.get(1)));
        } else {
            this.askConfirmation(user, () -> this.rename(user, from, to, (String)args.get(1)));
        }
        return true;
    }

    private void rename(User user, String blueprintName, String fileName, String displayName) {
        Blueprint blueprint = this.getPlugin().getBlueprintsManager().getBlueprints((GameModeAddon)this.getAddon()).get(blueprintName);
        this.getPlugin().getBlueprintsManager().renameBlueprint((GameModeAddon)this.getAddon(), blueprint, fileName, displayName);
        user.sendMessage("commands.admin.blueprint.rename.success", "[old]", blueprintName, "[name]", blueprint.getName(), "[display]", blueprint.getDisplayName());
    }
}

