/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.blueprints;

import java.io.File;
import java.util.List;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.commands.admin.blueprints.AdminBlueprintCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.blueprints.BlueprintClipboard;
import world.bentobox.bentobox.managers.BlueprintClipboardManager;
import world.bentobox.bentobox.util.Util;

public class AdminBlueprintSaveCommand
extends ConfirmableCommand {
    public AdminBlueprintSaveCommand(AdminBlueprintCommand parent) {
        super(parent, "save", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.blueprint.save");
        this.setParametersHelp("commands.admin.blueprint.save.parameters");
        this.setDescription("commands.admin.blueprint.save.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        BlueprintClipboard clipboard = ((AdminBlueprintCommand)this.getParent()).getClipboards().computeIfAbsent(user.getUniqueId(), v -> new BlueprintClipboard());
        if (!clipboard.isFull()) {
            user.sendMessage("commands.admin.blueprint.copy-first", new String[0]);
            return false;
        }
        if (clipboard.getBlueprint() != null && clipboard.getBlueprint().getBedrock() == null) {
            user.sendMessage("commands.admin.blueprint.bedrock-required", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        AdminBlueprintCommand parent = (AdminBlueprintCommand)this.getParent();
        BlueprintClipboard clipboard = parent.getClipboards().computeIfAbsent(user.getUniqueId(), v -> new BlueprintClipboard());
        String fileName = Util.sanitizeInput(args.get(0));
        File newFile = new File(parent.getBlueprintsFolder(), fileName + ".blu");
        if (newFile.exists()) {
            this.askConfirmation(user, user.getTranslation("commands.admin.blueprint.file-exists", new String[0]), () -> this.hideAndSave(user, parent, clipboard, fileName, (String)args.get(0)));
            return false;
        }
        return this.hideAndSave(user, parent, clipboard, fileName, args.get(0));
    }

    private boolean hideAndSave(User user, AdminBlueprintCommand parent, BlueprintClipboard clipboard, String name, String displayName) {
        parent.hideClipboard(user);
        boolean result = new BlueprintClipboardManager(this.getPlugin(), parent.getBlueprintsFolder(), clipboard).save(user, name, displayName);
        if (result && clipboard.isFull()) {
            this.getPlugin().getBlueprintsManager().addBlueprint((GameModeAddon)this.getAddon(), clipboard.getBlueprint());
        }
        return result;
    }
}

