/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.conversations;

import org.bukkit.Bukkit;
import org.bukkit.conversations.ConversationContext;
import org.bukkit.conversations.Prompt;
import org.bukkit.conversations.StringPrompt;
import org.bukkit.plugin.Plugin;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.BentoBox;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;

public class NamePrompt
extends StringPrompt {
    private final @NonNull Island island;
    private final @NonNull User user;
    private final String oldName;
    private final BentoBox plugin;

    public NamePrompt(BentoBox plugin, @NonNull Island island, @NonNull User user, String oldName) {
        this.plugin = plugin;
        this.island = island;
        this.user = user;
        this.oldName = oldName;
    }

    public @NonNull String getPromptText(@NonNull ConversationContext context) {
        return this.user.getTranslation("commands.island.renamehome.enter-new-name", new String[0]);
    }

    public Prompt acceptInput(@NonNull ConversationContext context, String input) {
        if (this.island.renameHome(this.oldName, input)) {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.user.sendMessage("general.success", new String[0]));
        } else {
            Bukkit.getScheduler().runTask((Plugin)this.plugin, () -> this.user.sendMessage("commands.island.renamehome.already-exists", new String[0]));
        }
        return Prompt.END_OF_CONVERSATION;
    }
}

