/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.deaths;

import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.deaths.AdminDeathsCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminDeathsRemoveCommand
extends CompositeCommand {
    public AdminDeathsRemoveCommand(AdminDeathsCommand parent) {
        super(parent, "remove", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.deaths.remove");
        this.setDescription("commands.admin.deaths.remove.description");
        this.setParametersHelp("commands.admin.deaths.remove.parameters");
    }

    @Override
    public boolean execute(User user, String label, @NonNull List<String> args) {
        if (args.size() != 2) {
            this.showHelp(this, user);
            return false;
        }
        UUID targetUUID = Util.getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
        } else if (!Util.isInteger(args.get(1), true) || Integer.parseInt(args.get(1)) < 0) {
            user.sendMessage("general.errors.must-be-positive-number", "[number]", args.get(1));
        } else {
            int newDeaths = Math.max(this.getPlayers().getDeaths(this.getWorld(), targetUUID) - Integer.parseInt(args.get(1)), 0);
            this.getPlayers().setDeaths(this.getWorld(), targetUUID, newDeaths);
            user.sendMessage("commands.admin.deaths.remove.success", "[name]", args.get(0), "[number]", args.get(1), "[total]", String.valueOf(newDeaths));
            return true;
        }
        return false;
    }
}

