/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.purge;

import java.util.List;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.purge.AdminPurgeCommand;
import world.bentobox.bentobox.api.user.User;

public class AdminPurgeStatusCommand
extends CompositeCommand {
    public AdminPurgeStatusCommand(AdminPurgeCommand parent) {
        super(parent, "status", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.purge.status");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.admin.purge.status.parameters");
        this.setDescription("commands.admin.purge.status.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        AdminPurgeCommand parentCommand = (AdminPurgeCommand)this.getParent();
        if (parentCommand.isInPurge()) {
            int purged = parentCommand.getPurgedIslandsCount();
            int purgeable = parentCommand.getPurgeableIslandsCount();
            user.sendMessage("commands.admin.purge.purge-in-progress", "[label]", this.getTopLabel());
            user.sendMessage("commands.admin.purge.status.status", "[purged]", String.valueOf(purged), "[purgeable]", String.valueOf(purgeable), "[percentage]", String.format("%.1f", Float.valueOf((float)purged / (float)purgeable * 100.0f)));
        } else {
            user.sendMessage("commands.admin.purge.no-purge-in-progress", new String[0]);
        }
        return true;
    }
}

