/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.range;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public abstract class AbstractAdminRangeCommand
extends CompositeCommand {
    protected @Nullable UUID targetUUID;
    protected Island targetIsland;

    public AbstractAdminRangeCommand(CompositeCommand parent, String string) {
        super(parent, string, new String[0]);
    }

    @Override
    public boolean canExecute(User user, String label, @NonNull List<String> args) {
        if (args.size() <= 1) {
            this.showHelp(this, user);
            return false;
        }
        this.targetUUID = Util.getUUID(args.get(0));
        if (this.targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        if (!Util.isInteger(args.get(1), true) || Integer.parseInt(args.get(1)) < 0) {
            user.sendMessage("general.errors.must-be-positive-number", "[number]", args.get(1));
            return false;
        }
        Map<String, Island> islands = this.getIslandsXYZ(this.targetUUID);
        if (islands.size() == 0) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        if (args.size() == 2) {
            if (islands.size() == 1) {
                this.targetIsland = islands.values().iterator().next();
                return true;
            }
            user.sendMessage("commands.admin.unregister.errors.player-has-more-than-one-island", new String[0]);
            user.sendMessage("commands.admin.unregister.errors.specify-island-location", new String[0]);
            return false;
        }
        if (args.size() != 3) {
            user.sendMessage("commands.admin.unregister.errors.specify-island-location", new String[0]);
            return false;
        }
        if (!islands.containsKey(args.get(2))) {
            if (args.get(2).equalsIgnoreCase("help")) {
                this.showHelp(this, user);
                return false;
            }
            user.sendMessage("commands.admin.unregister.errors.unknown-island-location", new String[0]);
            return false;
        }
        this.targetIsland = islands.get(args.get(2));
        return true;
    }

    protected Map<String, Island> getIslandsXYZ(UUID target) {
        return this.getIslands().getOwnedIslands(this.getWorld(), target).stream().collect(Collectors.toMap(island -> Util.xyz(island.getCenter().toVector()), island -> island));
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        UUID uuid;
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        if (args.size() == 3) {
            ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        if (args.size() > 4 && (uuid = this.getPlayers().getUUID(args.get(2))) != null) {
            return Optional.of(Util.tabLimit(new ArrayList<String>(this.getIslandsXYZ(uuid).keySet()), lastArg));
        }
        return Optional.empty();
    }
}

