/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.range;

import java.util.List;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.commands.admin.range.AbstractAdminRangeCommand;
import world.bentobox.bentobox.api.commands.admin.range.AdminRangeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;

public class AdminRangeAddCommand
extends AbstractAdminRangeCommand {
    public AdminRangeAddCommand(AdminRangeCommand parent) {
        super(parent, "add");
    }

    @Override
    public void setup() {
        this.setPermission("admin.range.add");
        this.setDescription("commands.admin.range.add.description");
        this.setParametersHelp("commands.admin.range.add.parameters");
    }

    @Override
    public boolean execute(User user, String label, @NonNull List<String> args) {
        int newRange = this.targetIsland.getProtectionRange() + Integer.parseInt(args.get(1));
        if (newRange > this.targetIsland.getRange()) {
            user.sendMessage("commands.admin.range.invalid-value.too-high", "[number]", String.valueOf(this.targetIsland.getRange()));
            return false;
        }
        if (newRange == this.targetIsland.getProtectionRange()) {
            user.sendMessage("commands.admin.range.invalid-value.same-as-before", "[number]", args.get(1));
            return false;
        }
        int oldRange = this.targetIsland.getProtectionRange();
        this.targetIsland.setProtectionRange(newRange);
        IslandEvent.builder().island(this.targetIsland).location(this.targetIsland.getCenter()).reason(IslandEvent.Reason.RANGE_CHANGE).involvedPlayer(this.targetUUID).admin(true).protectionRange(newRange, oldRange).build();
        user.sendMessage("commands.admin.range.add.success", "[name]", args.get(0), "[number]", args.get(1), "[total]", String.valueOf(newRange));
        return true;
    }
}

