/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.range;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.Util;

public class AdminRangeResetCommand
extends CompositeCommand {
    public AdminRangeResetCommand(CompositeCommand parent) {
        super(parent, "reset", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.range.reset");
        this.setParametersHelp("commands.admin.range.reset.parameters");
        this.setDescription("commands.admin.range.reset.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        UUID targetUUID = Util.getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        if (!this.getIslands().hasIsland(this.getWorld(), targetUUID) && !this.getIslands().inTeam(this.getWorld(), targetUUID)) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        Island island = Objects.requireNonNull(this.getIslands().getIsland(this.getWorld(), targetUUID));
        int oldRange = island.getProtectionRange();
        int range = this.getIWM().getIslandProtectionRange(this.getWorld());
        island.setProtectionRange(range);
        if (oldRange != range) {
            IslandEvent.builder().island(island).location(island.getCenter()).reason(IslandEvent.Reason.RANGE_CHANGE).involvedPlayer(targetUUID).admin(true).protectionRange(range, oldRange).build();
        }
        user.sendMessage("commands.admin.range.reset.success", "[number]", String.valueOf(range));
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (args.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

