/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.resets;

import java.util.List;
import java.util.UUID;
import org.eclipse.jdt.annotation.NonNull;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.admin.resets.AdminResetsCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminResetsRemoveCommand
extends CompositeCommand {
    public AdminResetsRemoveCommand(AdminResetsCommand parent) {
        super(parent, "remove", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.resets.remove");
        this.setDescription("commands.admin.resets.remove.description");
        this.setParametersHelp("commands.admin.resets.remove.parameters");
    }

    @Override
    public boolean execute(User user, String label, @NonNull List<String> args) {
        if (args.size() != 2) {
            this.showHelp(this, user);
            return false;
        }
        UUID targetUUID = Util.getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
        } else if (!Util.isInteger(args.get(1), true) || Integer.parseInt(args.get(1)) < 0) {
            user.sendMessage("general.errors.must-be-positive-number", "[number]", args.get(1));
        } else {
            int newResets = Math.max(this.getPlayers().getResets(this.getWorld(), targetUUID) - Integer.parseInt(args.get(1)), 0);
            this.getPlayers().setResets(this.getWorld(), targetUUID, newResets);
            user.sendMessage("commands.admin.resets.remove.success", "[name]", args.get(0), "[number]", args.get(1), "[total]", String.valueOf(newResets));
            return true;
        }
        return false;
    }
}

