/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.admin.resets;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.commands.ConfirmableCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.util.Util;

public class AdminResetsResetCommand
extends ConfirmableCommand {
    public AdminResetsResetCommand(CompositeCommand parent) {
        super(parent, "reset", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("admin.resets.remove");
        this.setDescription("commands.admin.resets.reset.description");
        this.setParametersHelp("commands.admin.resets.reset.parameters");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        if (args.get(0).equalsIgnoreCase("@a")) {
            this.askConfirmation(user, () -> {
                this.getIWM().setResetEpoch(this.getWorld());
                Bukkit.getOnlinePlayers().stream().map(OfflinePlayer::getUniqueId).filter(this.getPlayers()::isKnown).forEach(u -> this.getPlayers().setResets(this.getWorld(), (UUID)u, 0));
                user.sendMessage("commands.admin.resets.reset.success-everyone", new String[0]);
            });
            return true;
        }
        UUID targetUUID = Util.getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        this.getPlayers().setResets(this.getWorld(), targetUUID, 0);
        user.sendMessage("commands.admin.resets.reset.success", "[name]", args.get(0));
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        return Optional.of(Collections.singletonList("@a"));
    }
}

