/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.NonNull;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandBanCommand
extends CompositeCommand {
    private @Nullable User target;

    public IslandBanCommand(CompositeCommand islandCommand) {
        super(islandCommand, "ban", new String[0]);
    }

    @Override
    public void setup() {
        this.setPermission("island.ban");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.ban.parameters");
        this.setDescription("commands.island.ban.description");
        this.setConfigurableRankCommand();
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        UUID playerUUID = user.getUniqueId();
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId()) && !this.getIslands().hasIsland(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        Island island = Objects.requireNonNull(this.getIslands().getIsland(this.getWorld(), user));
        int rank = island.getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        UUID targetUUID = this.getPlayers().getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        if (playerUUID.equals(targetUUID)) {
            user.sendMessage("commands.island.ban.cannot-ban-yourself", new String[0]);
            return false;
        }
        if (this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId()).inTeam(targetUUID)) {
            user.sendMessage("commands.island.ban.cannot-ban-member", new String[0]);
            return false;
        }
        if (island.isBanned(targetUUID)) {
            user.sendMessage("commands.island.ban.player-already-banned", new String[0]);
            return false;
        }
        if (this.getSettings().getBanCooldown() > 0 && this.checkCooldown(user, island.getUniqueId(), targetUUID.toString())) {
            return false;
        }
        this.target = User.getInstance(targetUUID);
        if (this.target.isOp() || this.target.isOnline() && this.target.hasPermission(this.getPermissionPrefix() + "admin.noban")) {
            user.sendMessage("commands.island.ban.cannot-ban", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        return this.ban(user, this.target);
    }

    private boolean ban(@NonNull User issuer, User target) {
        Island island = Objects.requireNonNull(this.getIslands().getIsland(this.getWorld(), issuer.getUniqueId()));
        int banLimit = issuer.getPermissionValue(this.getPermissionPrefix() + "ban.maxlimit", this.getIWM().getBanLimit(this.getWorld()));
        if (banLimit <= -1 || island.getBanned().size() < banLimit) {
            IslandBaseEvent banEvent = IslandEvent.builder().island(island).involvedPlayer(target.getUniqueId()).admin(false).reason(IslandEvent.Reason.BAN).build();
            if (banEvent.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(banEvent.isCancelled()).booleanValue()) {
                return false;
            }
            if (island.ban(issuer.getUniqueId(), target.getUniqueId())) {
                issuer.sendMessage("commands.island.ban.player-banned", "[name]", target.getName(), "[display_name]", target.getDisplayName());
                target.sendMessage("commands.island.ban.owner-banned-you", "[name]", issuer.getName(), "[display_name]", issuer.getDisplayName());
                if (target.isOnline() && this.getIslands().hasIsland(this.getWorld(), target.getUniqueId()) && island.onIsland(target.getLocation())) {
                    this.getIslands().homeTeleportAsync(this.getWorld(), target.getPlayer());
                    island.getWorld().playSound(target.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
                }
                return true;
            }
        } else {
            issuer.sendMessage("commands.island.ban.cannot-ban-more-players", new String[0]);
        }
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (lastArg.isEmpty()) {
            return Optional.empty();
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        if (island != null) {
            List<String> options = Bukkit.getOnlinePlayers().stream().filter(p -> !p.getUniqueId().equals(user.getUniqueId())).filter(p -> !island.isBanned(p.getUniqueId())).filter(p -> user.getPlayer().canSee(p)).map(Player::getName).toList();
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        return Optional.empty();
    }
}

