/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;

public class IslandBanlistCommand
extends CompositeCommand {
    private Island island;

    public IslandBanlistCommand(CompositeCommand islandCommand) {
        super(islandCommand, "banlist", "banned", "bans");
    }

    @Override
    public void setup() {
        this.setPermission("island.ban");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.banlist.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            this.showHelp(this, user);
            return false;
        }
        if (!this.getIslands().hasIsland(this.getWorld(), user.getUniqueId()) && !this.getIslands().inTeam(this.getWorld(), user.getUniqueId())) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        this.island = this.getIslands().getIsland(this.getWorld(), user.getUniqueId());
        int rank = Objects.requireNonNull(this.island).getRank(user);
        if (rank < this.island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (this.island.getBanned().isEmpty()) {
            user.sendMessage("commands.island.banlist.noone", new String[0]);
            return true;
        }
        user.sendMessage("commands.island.banlist.the-following", new String[0]);
        List<String> names = this.island.getBanned().stream().map(u -> this.getPlayers().getName((UUID)u)).sorted().toList();
        ArrayList<String> lines = new ArrayList<String>();
        StringBuilder line = new StringBuilder();
        names.forEach(n -> {
            if (line.length() + n.length() >= 41) {
                lines.add(line.toString().trim());
                line.setLength(0);
            }
            line.append((String)n);
            line.append(", ");
        });
        line.setLength(line.length() - 2);
        if (line.length() > 0) {
            lines.add(line.toString());
        }
        lines.forEach(l -> user.sendMessage("commands.island.banlist.names", "[line]", (String)l));
        int banLimit = user.getPermissionValue(this.getPermissionPrefix() + "ban.maxlimit", this.getIWM().getBanLimit(this.getWorld()));
        if (banLimit > -1 && this.island.getBanned().size() < banLimit) {
            user.sendMessage("commands.island.banlist.you-can-ban", "[number]", String.valueOf(banLimit - this.island.getBanned().size()));
        }
        return true;
    }
}

