/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.io.IOException;
import java.util.List;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.addons.GameModeAddon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.island.NewIsland;
import world.bentobox.bentobox.panels.customizable.IslandCreationPanel;
import world.bentobox.bentobox.util.Util;

public class IslandCreateCommand
extends CompositeCommand {
    public IslandCreateCommand(CompositeCommand islandCommand) {
        super(islandCommand, "create", "new");
    }

    @Override
    public void setup() {
        this.setPermission("island.create");
        this.setOnlyPlayer(true);
        this.setParametersHelp("commands.island.create.parameters");
        this.setDescription("commands.island.create.description");
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        int max;
        @Nullable Island island = this.getIslands().getPrimaryIsland(this.getWorld(), user.getUniqueId());
        if (island != null && island.isReserved()) {
            return true;
        }
        if (this.getIWM().getWorldSettings(this.getWorld()).isDisallowTeamMemberIslands() && this.getIslands().inTeam(this.getWorld(), user.getUniqueId()) && island != null && !user.getUniqueId().equals(island.getOwner())) {
            user.sendMessage("commands.island.create.you-cannot-make-team", new String[0]);
            return false;
        }
        int num = this.getIslands().getNumberOfConcurrentIslands(user.getUniqueId(), this.getWorld());
        if (num >= (max = user.getPermissionValue(this.getIWM().getAddon(this.getWorld()).map(Addon::getPermissionPrefix).orElse("") + "island.number", this.getIWM().getWorldSettings(this.getWorld()).getConcurrentIslands()))) {
            user.sendMessage("commands.island.create.you-cannot-make", new String[0]);
            return false;
        }
        if (this.getIWM().getMaxIslands(this.getWorld()) > 0 && this.getIslands().getIslandCount(this.getWorld()) >= (long)this.getIWM().getMaxIslands(this.getWorld())) {
            user.sendMessage("commands.island.create.too-many-islands", new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (!args.isEmpty()) {
            String name = this.getPlugin().getBlueprintsManager().validate((GameModeAddon)this.getAddon(), Util.sanitizeInput(args.get(0)));
            if (name == null) {
                user.sendMessage("commands.island.create.unknown-blueprint", new String[0]);
                return false;
            }
            if (!this.getPlugin().getBlueprintsManager().checkPerm((Addon)this.getAddon(), user, Util.sanitizeInput(args.get(0)))) {
                return false;
            }
            if (this.checkMaxUses(user, name)) {
                return false;
            }
            return this.makeIsland(user, name);
        }
        if (this.getPlugin().getSettings().getIslandNumber() > 1 && this.checkMaxUses(user, "default")) {
            return false;
        }
        if (this.getPlugin().getBlueprintsManager().getBlueprintBundles((GameModeAddon)this.getAddon()).size() > 1) {
            IslandCreationPanel.openPanel(this, user, label, false);
            return true;
        }
        return this.makeIsland(user, "default");
    }

    private boolean checkMaxUses(User user, String name) {
        int maxTimes;
        if (this.getPlugin().getBlueprintsManager().getBlueprintBundles((GameModeAddon)this.getAddon()).containsKey(name) && (maxTimes = this.getPlugin().getBlueprintsManager().getBlueprintBundles((GameModeAddon)this.getAddon()).get(name).getTimes()) > 0 && this.getBundleUses(user, name) >= (long)maxTimes) {
            user.sendMessage("commands.island.create.max-uses", new String[0]);
            return true;
        }
        return false;
    }

    private long getBundleUses(User user, String name) {
        return this.getIslands().getIslands(this.getWorld(), user).stream().filter(is -> is.getMetaData("bundle").map(mdv -> name.equalsIgnoreCase(mdv.asString())).orElse(false)).count();
    }

    private boolean makeIsland(User user, String name) {
        user.sendMessage("commands.island.create.creating-island", new String[0]);
        try {
            NewIsland.builder().player(user).addon((GameModeAddon)this.getAddon()).reason(IslandEvent.Reason.CREATE).name(name).build();
        }
        catch (IOException e) {
            this.getPlugin().logError("Could not create island for player. " + e.getMessage());
            user.sendMessage(e.getMessage(), new String[0]);
            return false;
        }
        if (this.getSettings().isResetCooldownOnCreate()) {
            this.getParent().getSubCommand("reset").ifPresent(resetCommand -> resetCommand.setCooldown(user.getUniqueId(), this.getSettings().getResetCooldown()));
        }
        return true;
    }
}

