/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import org.bukkit.Bukkit;
import org.bukkit.Sound;
import org.bukkit.entity.Player;
import org.eclipse.jdt.annotation.Nullable;
import world.bentobox.bentobox.api.addons.Addon;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.events.IslandBaseEvent;
import world.bentobox.bentobox.api.events.island.IslandEvent;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.managers.RanksManager;
import world.bentobox.bentobox.util.Util;

public class IslandExpelCommand
extends CompositeCommand {
    private static final String CANNOT_EXPEL = "commands.island.expel.cannot-expel";
    private static final String SUCCESS = "commands.island.expel.success";
    private @Nullable User target;

    public IslandExpelCommand(CompositeCommand islandCommand) {
        super(islandCommand, "expel", new String[0]);
    }

    @Override
    public void setup() {
        this.setOnlyPlayer(true);
        this.setPermission("island.expel");
        this.setParametersHelp("commands.island.expel.parameters");
        this.setDescription("commands.island.expel.description");
        this.setConfigurableRankCommand();
    }

    @Override
    public boolean canExecute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            this.showHelp(this, user);
            return false;
        }
        UUID playerUUID = user.getUniqueId();
        if (!this.getIslands().inTeam(this.getWorld(), user.getUniqueId()) && !this.getIslands().hasIsland(this.getWorld(), user)) {
            user.sendMessage("general.errors.no-island", new String[0]);
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        int rank = Objects.requireNonNull(island).getRank(user);
        if (rank < island.getRankCommand(this.getUsage())) {
            user.sendMessage("general.errors.insufficient-rank", "[rank]", user.getTranslation(RanksManager.getInstance().getRank(rank), new String[0]));
            return false;
        }
        UUID targetUUID = this.getPlayers().getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        if (playerUUID.equals(targetUUID)) {
            user.sendMessage("commands.island.expel.cannot-expel-yourself", new String[0]);
            return false;
        }
        if (island.inTeam(targetUUID)) {
            user.sendMessage("commands.island.expel.cannot-expel-member", new String[0]);
            return false;
        }
        this.target = User.getInstance(targetUUID);
        if (!this.target.isOnline() || !user.getPlayer().canSee(Bukkit.getPlayer((UUID)targetUUID))) {
            user.sendMessage("general.errors.offline-player", new String[0]);
            return false;
        }
        if (!this.getIslands().locationIsOnIsland(user.getPlayer(), this.target.getLocation())) {
            user.sendMessage("commands.island.expel.not-on-island", new String[0]);
            return false;
        }
        if (this.target.isOp() || this.target.hasPermission(this.getPermissionPrefix() + "admin.noexpel") || this.target.hasPermission(this.getPermissionPrefix() + "mod.bypassexpel")) {
            user.sendMessage(CANNOT_EXPEL, new String[0]);
            return false;
        }
        return true;
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        IslandBaseEvent expelEvent = IslandEvent.builder().island(island).involvedPlayer(this.target.getUniqueId()).admin(false).reason(IslandEvent.Reason.EXPEL).build();
        if (expelEvent.getNewEvent().map(IslandBaseEvent::isCancelled).orElse(expelEvent.isCancelled()).booleanValue()) {
            user.sendMessage(CANNOT_EXPEL, new String[0]);
            return false;
        }
        this.target.sendMessage("commands.island.expel.player-expelled-you", "[name]", user.getName(), "[display_name]", user.getDisplayName());
        island.getWorld().playSound(this.target.getLocation(), Sound.ENTITY_GENERIC_EXPLODE, 1.0f, 1.0f);
        if (this.getIslands().hasIsland(this.getWorld(), this.target) || this.getIslands().inTeam(this.getWorld(), this.target.getUniqueId())) {
            user.sendMessage(SUCCESS, "[name]", this.target.getName(), "[display_name]", this.target.getDisplayName());
            this.getIslands().homeTeleportAsync(this.getWorld(), this.target.getPlayer());
            return true;
        }
        if (this.getIslands().getSpawn(this.getWorld()).isPresent()) {
            user.sendMessage(SUCCESS, "[name]", this.target.getName(), "[display_name]", this.target.getDisplayName());
            this.getIslands().spawnTeleport(this.getWorld(), this.target.getPlayer());
            return true;
        }
        if (this.getIWM().getAddon(this.getWorld()).map(gm -> gm.getPlayerCommand().map(pc -> pc.getSubCommand("create").isPresent()).orElse(false)).orElse(false).booleanValue() && this.target.performCommand(this.getTopLabel() + " create")) {
            ((Addon)this.getAddon()).logWarning("Expel: " + this.target.getName() + " had no island, so one was created");
            user.sendMessage(SUCCESS, "[name]", this.target.getName(), "[display_name]", this.target.getDisplayName());
            return true;
        }
        ((Addon)this.getAddon()).logError("Expel: " + this.target.getName() + " had no island, and one could not be created");
        user.sendMessage(CANNOT_EXPEL, new String[0]);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        Island island = this.getIslands().getIsland(this.getWorld(), user);
        if (island != null) {
            List<String> options = island.getPlayersOnIsland().stream().filter(p -> !p.equals((Object)user.getPlayer())).filter(p -> user.getPlayer().canSee(p)).filter(p -> !p.isOp()).filter(p -> !p.hasPermission(this.getPermissionPrefix() + "admin.noexpel")).filter(p -> !p.hasPermission(this.getPermissionPrefix() + "mod.bypassexpel")).map(Player::getName).toList();
            String lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
            return Optional.of(Util.tabLimit(options, lastArg));
        }
        return Optional.empty();
    }
}

