/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.database.objects.Island;
import world.bentobox.bentobox.util.IslandInfo;
import world.bentobox.bentobox.util.Util;

public class IslandInfoCommand
extends CompositeCommand {
    public IslandInfoCommand(CompositeCommand parent) {
        super(parent, "info", "who");
    }

    @Override
    public void setup() {
        this.setPermission("island.info");
        this.setOnlyPlayer(false);
        this.setParametersHelp("commands.island.info.parameters");
        this.setDescription("commands.island.info.description");
    }

    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() > 1 || args.isEmpty() && !user.isPlayer()) {
            this.showHelp(this, user);
            return false;
        }
        if (args.isEmpty()) {
            if (!this.getIslands().getIslandAt(user.getLocation()).map(i -> new IslandInfo((Island)i).showInfo(user)).orElse(false).booleanValue()) {
                user.sendMessage("commands.admin.info.no-island", new String[0]);
                return false;
            }
            return true;
        }
        UUID targetUUID = this.getPlayers().getUUID(args.get(0));
        if (targetUUID == null) {
            user.sendMessage("general.errors.unknown-player", "[name]", args.get(0));
            return false;
        }
        Island island = this.getIslands().getIsland(this.getWorld(), targetUUID);
        if (island == null) {
            user.sendMessage("general.errors.player-has-no-island", new String[0]);
            return false;
        }
        new IslandInfo(island).showInfo(user);
        return true;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        String lastArg;
        String string = lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        if (lastArg.isEmpty()) {
            return Optional.empty();
        }
        ArrayList<String> options = new ArrayList<String>(Util.getOnlinePlayerList(user));
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

