/*
 * Decompiled with CFR 0.152.
 */
package world.bentobox.bentobox.api.commands.island;

import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Optional;
import world.bentobox.bentobox.api.commands.CompositeCommand;
import world.bentobox.bentobox.api.user.User;
import world.bentobox.bentobox.panels.customizable.LanguagePanel;
import world.bentobox.bentobox.util.Util;

public class IslandLanguageCommand
extends CompositeCommand {
    public IslandLanguageCommand(CompositeCommand islandCommand) {
        super(islandCommand, "language", "lang");
    }

    @Override
    public void setup() {
        this.setPermission("island.language");
        this.setOnlyPlayer(true);
        this.setDescription("commands.island.language.description");
        this.setParametersHelp("commands.island.language.parameters");
    }

    /*
     * Enabled aggressive block sorting
     */
    @Override
    public boolean execute(User user, String label, List<String> args) {
        if (args.size() != 1) {
            LanguagePanel.openPanel(this, user);
            return true;
        }
        Locale locale = Locale.forLanguageTag(args.get(0));
        if (!this.getPlugin().getLocalesManager().isLocaleAvailable(locale)) {
            user.sendMessage("commands.island.language.not-available", new String[0]);
            return false;
        }
        if (!user.getLocale().equals(locale)) {
            this.getPlugin().getPlayers().setLocale(user.getUniqueId(), locale.toLanguageTag());
            user.sendMessage("panels.language.edited", "[lang]", locale.toLanguageTag());
            return true;
        }
        user.sendMessage("commands.island.language.already-selected", new String[0]);
        return false;
    }

    @Override
    public Optional<List<String>> tabComplete(User user, String alias, List<String> args) {
        ArrayList<String> options = new ArrayList<String>();
        String lastArg = !args.isEmpty() ? args.get(args.size() - 1) : "";
        for (Locale locale : this.getPlugin().getLocalesManager().getAvailableLocales(true)) {
            options.add(locale.toLanguageTag());
        }
        return Optional.of(Util.tabLimit(options, lastArg));
    }
}

